/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.saxon.evpull.EndElementEvent;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.EventStackIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.evpull.StartElementEvent;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.trans.XPathException;

public class NamespaceMaintainer
implements EventIterator,
NamespaceResolver {
    private EventIterator base;
    private NamePool namePool;
    private int[] allNamespaces = new int[50];
    private int allNamespacesSize = 0;
    private int[] namespaceCountStack = new int[50];
    private int depth = 0;

    public NamespaceMaintainer(EventIterator base, NamePool namePool) {
        this.base = EventStackIterator.flatten(base);
        this.namePool = namePool;
    }

    public boolean isFlatSequence() {
        return true;
    }

    public PullEvent next() throws XPathException {
        PullEvent event = this.base.next();
        if (event instanceof StartElementEvent) {
            this.startElement((StartElementEvent)event);
        } else if (event instanceof EndElementEvent) {
            this.endElement();
        }
        return event;
    }

    private void startElement(StartElementEvent event) throws XPathException {
        int i;
        int[] declaredNamespaces = event.getLocalNamespaces();
        int numberOfDeclaredNamespaces = declaredNamespaces.length;
        for (i = 0; i < declaredNamespaces.length; ++i) {
            if (declaredNamespaces[i] != -1) continue;
            numberOfDeclaredNamespaces = i;
            break;
        }
        if (this.depth >= this.namespaceCountStack.length) {
            int[] newstack = new int[this.depth * 2];
            System.arraycopy(this.namespaceCountStack, 0, newstack, 0, this.depth);
            this.namespaceCountStack = newstack;
        }
        this.namespaceCountStack[this.depth++] = numberOfDeclaredNamespaces;
        while (this.allNamespacesSize + numberOfDeclaredNamespaces >= this.allNamespaces.length) {
            int[] newlist = new int[this.allNamespacesSize * 2];
            System.arraycopy(this.allNamespaces, 0, newlist, 0, this.allNamespacesSize);
            this.allNamespaces = newlist;
        }
        for (i = 0; i < declaredNamespaces.length && declaredNamespaces[i] != -1; ++i) {
            this.allNamespaces[this.allNamespacesSize++] = declaredNamespaces[i];
        }
    }

    private void endElement() {
        this.allNamespacesSize -= this.namespaceCountStack[--this.depth];
    }

    protected short getURICode(short prefixCode) {
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            if (this.allNamespaces[i] >> 16 != prefixCode) continue;
            return (short)(this.allNamespaces[i] & 0xFFFF);
        }
        if (prefixCode == 0) {
            return 0;
        }
        return -1;
    }

    public String getURIForPrefix(String prefix, boolean useDefault) {
        if (!(prefix != null && prefix.length() != 0 || useDefault)) {
            return "";
        }
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        short prefixCode = this.namePool.getCodeForPrefix(prefix);
        short uriCode = this.getURICode(prefixCode);
        if (uriCode == -1) {
            return null;
        }
        return this.namePool.getURIFromURICode(uriCode);
    }

    public Iterator iteratePrefixes() {
        ArrayList<String> prefixes = new ArrayList<String>(this.allNamespacesSize);
        for (int i = this.allNamespacesSize - 1; i >= 0; --i) {
            String prefix = this.namePool.getPrefixFromNamespaceCode(this.allNamespaces[i]);
            if (prefixes.contains(prefix)) continue;
            prefixes.add(prefix);
        }
        prefixes.add("xml");
        return prefixes.iterator();
    }
}

