// -*- mode: js; js-indent-level: 4; indent-tabs-mode: nil -*-
var Cu = Components.utils;
var Ci = Components.interfaces;
var Cc = Components.classes;
var Cr = Components.results;

Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/ctypes.jsm");

Cu.import("resource://unity/unity-global-property-initializer.js");

var pbs = (function () {
    var privateBrowsingService = null;
    function _tryGetDeprecatedPrivateBrowsingService () {
        var service = null;
        try {
            service = Cc["@mozilla.org/privatebrowsing;1"].getService(Ci.nsIPrivateBrowsingService);
            // validate that we are not using the dummy stub version: see https://bugzilla.mozilla.org/show_bug.cgi?id=826037#c16
            // & https://bugzilla.mozilla.org/attachment.cgi?id=697195&action=diff
            if (service !== null && !("privateBrowsingEnabled" in service))
                service = null;
        }
        catch (e) {
            // we are in the case where it has been removed and w/o the stub
        }
        return service;
    }
    privateBrowsingService = _tryGetDeprecatedPrivateBrowsingService();

    function _makePrivateBrowsingWithBackend(backend) {
        return { privateBrowsingEnabled: backend };
    }
    if (privateBrowsingService !== null)
        return _makePrivateBrowsingWithBackend(function(aWindow) { return privateBrowsingService.privateBrowsingEnabled });

    var privateBrowsingUtils = Cu.import('resource://gre/modules/PrivateBrowsingUtils.jsm', {}).PrivateBrowsingUtils;
    return _makePrivateBrowsingWithBackend(function(aWindow) { return privateBrowsingUtils.isWindowPrivate(aWindow); });
}) ();

var observerService = Cc["@mozilla.org/observer-service;1"].getService(Components.interfaces.nsIObserverService);

function forEachWindow(func) {
    var wm = Components.classes["@mozilla.org/appshell/window-mediator;1"]
        .getService(Components.interfaces.nsIWindowMediator);
    var browserEnumerator = wm.getEnumerator("navigator:browser");

    var found = false;
    while (!found && browserEnumerator.hasMoreElements()) {
        var browserWin = browserEnumerator.getNext();

        func(browserWin);
    }

}

function Observer() {
    this._init();
}

Observer.prototype = {
    _init: function () {
    },

    activate: function() {
        observerService.addObserver(this, 'content-document-global-created', false);
    },

    deactivate: function() {
        UnityGlobalPropertyInitializer.disconnectAll();

        observerService.removeObserver(this, 'content-document-global-created');
    },

    observe : function(aWindow, aTopic, aData) {
        if (aWindow instanceof Ci.nsIDOMWindow && aTopic == 'content-document-global-created') {
            if (pbs && pbs.privateBrowsingEnabled(aWindow))
                return;

            UnityGlobalPropertyInitializer.handle(aWindow);
        }
    }
};

var EXPORTED_SYMBOLS = [ "Observer" ];
