/*
 * Decompiled with CFR 0.152.
 */
package com.android.dex;

public final class DexFormat {
    public static final int API_CURRENT = 14;
    public static final int API_NO_EXTENDED_OPCODES = 13;
    public static final String DEX_IN_JAR_NAME = "classes.dex";
    public static final String MAGIC_PREFIX = "dex\n";
    public static final String MAGIC_SUFFIX = "\u0000";
    public static final String VERSION_CURRENT = "036";
    public static final String VERSION_FOR_API_13 = "035";
    public static final int ENDIAN_TAG = 305419896;

    private DexFormat() {
    }

    public static int magicToApi(byte[] byArray) {
        if (byArray.length != 8) {
            return -1;
        }
        if (byArray[0] != 100 || byArray[1] != 101 || byArray[2] != 120 || byArray[3] != 10 || byArray[7] != 0) {
            return -1;
        }
        String string = "" + (char)byArray[4] + (char)byArray[5] + (char)byArray[6];
        if (string.equals(VERSION_CURRENT)) {
            return 14;
        }
        if (string.equals(VERSION_FOR_API_13)) {
            return 13;
        }
        return -1;
    }

    public static String apiToMagic(int n) {
        String string = n >= 14 ? VERSION_CURRENT : VERSION_FOR_API_13;
        return MAGIC_PREFIX + string + MAGIC_SUFFIX;
    }
}

