      SUBROUTINE SETFND(*,SET,LSET,ID,NEXT)
C*****
C  FINDS AN ID IN A SORTED SET LIST WHICH MAY HAVE THE NASTRAN THROUGH
C  NOTATION.  IE.  6,-18 IMPLIES 6 THRU 18.
C
C  -SET- IS THE LIST OF IDS.
C  -LSET- IS THE LENGTH OF THE LIST IN -SET-.
C  -ID- IS THE ID BEING LOOKED FOR IN THE LIST -SET-.
C  -NEXT- IS A RELATIVE INDEX INTO THE LIST -SET-.  IT SHOULD BE SET
C  TO 1 ON THE FIRST CALL TO THIS ROUTINE FOR A GIVEN LIST AND THEN
C  RETURNED ON FUTURE CALLS.
C
C  THIS ROUTINE MOVES FORWARD ONLY UNTIL AN ID IN THE LIST IS GREATER
C  THAN THE ID BEING ASKED FOR.    -NEXT-  IF NOT RESET TO 1 WILL ALLOW
C  THE ROUTINE TO SEARCH ONLY FROM WHERE LAST SEARCH LEFT OFF.
C
C  THE NON-STANDARD RETURN IS TAKEN IN THE EVENT THE ID IS NOT IN THE
C  LIST.  A NORMAL RETURN IS TAKEN IF THE ID IS IN THE LIST.
C
C  -NEXT- SHOULD BE SET TO 1 ON THE FIRST CALL TO THIS ROUTINE OR WHEN
C  AN ID TO BE LOOKED FOR IS SMALLER THAN AN ID PREVIOUSLY LOOKED FOR.
C
C  IF IDS TO BE LOOKED FOR ARE NOT IN SORT AND THE SET LIST IS IN SORT
C  WITHOUT THE NASTRAN THROUGH NOTATION, THEN THE NASTRAN BINARY SEARCH
C  ROUTINE -BISRCH- SHOULD BE USED.
C
C  IT IS OK TO CALL THIS ROUTINE WITH MORE THAN ONE OF THE SAME IDS
C  WITHOUT RESETTING -NEXT-.
C*****
      INTEGER SET(LSET)
C
   10 ID1 = SET(NEXT)
   20 IF( NEXT - LSET ) 30,80,100
C
C     STILL POSITIONED WITHIN THE SET LIST.
C
   30 IF( ID - ID1 ) 100,110,40
C
C     CHECK FOR THRU CASE
C
   40 ID1 = SET(NEXT+1)
      IF( ID1 ) 50,70,70
C
C     YES POSITIONED IN A THRU CASE
C
   50 IF( ID + ID1 ) 110,110,60
C
C     ID BEING LOOKED FOR IS BEYOND THIS THRU CASE.
C
   60 NEXT = NEXT + 2
      GO TO 10
C
C     NOT IN A THRU CASE
C
   70 NEXT = NEXT + 1
      GO TO 20
C
C     AT THE LAST ID IN THE LIST
C
   80 IF( ID - ID1 ) 100,110,90
   90 NEXT = NEXT + 1
  100 RETURN 1
  110 RETURN
      END
