/*
 * generated by Xtext 2.26.0
 */
package org.neu.acl2.handproof.generator;

import java.util.ArrayList;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.AbstractGenerator;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.generator.IGeneratorContext;
import org.neu.acl2.handproof.handProof.ProofDocument;
import org.neu.acl2.handproof.util.CheckerValueConverter;

import com.google.common.collect.Iterators;

/**
 * Generates code from your model files on save.
 * 
 * See
 * https://www.eclipse.org/Xtext/documentation/303_runtime_concepts.html#code-generation
 */
public class HandProofGenerator extends AbstractGenerator {

	@Override
	public void doGenerate(Resource resource, IFileSystemAccess2 fsa, IGeneratorContext context) {
		var docs = Iterators.filter(resource.getAllContents(), ProofDocument.class::isInstance);
		if (!docs.hasNext()) {
			return;
		}
		var doc = docs.next();
		if (doc == null) {
			return;
		}
		var allNodes = new ArrayList<EObject>();
		doc.eAllContents().forEachRemaining(node -> allNodes.add(node));
		var cv = new CheckerValueConverter(allNodes);

		var docLisp = "";
		try {
			docLisp = cv.toLisp(doc);
		} catch (Exception e) {
			System.err.println(e);
			throw e;
		}
		fsa.generateFile("output.proof", docLisp);
	}
}
