/**
 * Copyright (C) 2003 Billy Biggs <vektor@dumbterm.net>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

#ifndef JPEGINPUT_H_INCLUDED
#define JPEGINPUT_H_INCLUDED

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Example usage:
 *
 * jpeginput_t *jpgin = jpeginput_new( "myimage.jpg", 0 );
 *
 * for( i = 0; i < jpeginput_get_height( jpgin ); i++ ) {
 *     uint8_t *scanline = jpeginput_get_scanline( jpgin, i );
 *
 *     for( x = 0; x < jpeginput_get_width( jpgin ); x++ ) {
 *         r = scanline[ (x * 3) + 0 ];
 *         g = scanline[ (x * 3) + 1 ];
 *         b = scanline[ (x * 3) + 2 ];
 *     }
 * }
 *
 * jpeginput_delete( jpgin );
 */


typedef struct jpeginput_s jpeginput_t;

/**
 * Opens the filename as a jpeg file.  Returns 0 on error.  If ycbcr
 * is true, pixels are YCbCr instead of RGB.  Note that it's not
 * really Y'CbCr like in video, but weird JFIF style silliness.
 */
jpeginput_t *jpeginput_new( const char *filename, int ycbcr );

/**
 * Closes the jpeg file.
 */
void jpeginput_delete( jpeginput_t *jpeginput );

/**
 * Returns the width of the jpeg file.
 */
unsigned int jpeginput_get_width( jpeginput_t *jpeginput );

/**
 * Returns the height of the jpeg file.
 */
unsigned int jpeginput_get_height( jpeginput_t *jpeginput );

/**
 * Returns a pointer to the given scanline from 0 to height-1.
 */
uint8_t *jpeginput_get_scanline( jpeginput_t *jpeginput, int num );

#ifdef __cplusplus
};
#endif
#endif /* JPEGINPUT_H_INCLUDED */
