# Генераторы проектов - Шаблоны

Чтобы начать работу быстрее, Вы можете использовать "генераторы проектов", в которые включены множество начальных настроек для функций безопасности, баз данных и некоторые  <dfn title="также известные как маршруты, URLы, ручки, ">эндпоинты</dfn> API.

В генераторе проектов всегда будут предустановлены какие-то настройки, которые Вам следует обновить и подогнать под свои нужды, но это может быть хорошей отправной точкой для Вашего проекта.

## Full Stack FastAPI PostgreSQL

GitHub: <a href="https://github.com/tiangolo/full-stack-fastapi-postgresql" class="external-link" target="_blank">https://github.com/tiangolo/full-stack-fastapi-postgresql</a>

### Full Stack FastAPI PostgreSQL - Особенности

* Полностью интегрирован с **Docker** (основан на Docker).
* Развёртывается в режиме Docker Swarm.
* Интегрирован с **Docker Compose** и оптимизирован для локальной разработки.
* **Готовый к реальной работе** веб-сервер Python использующий Uvicorn и Gunicorn.
* Бэкенд построен на фреймворке <a href="https://github.com/tiangolo/fastapi" class="external-link" target="_blank">**FastAPI**</a>:
    * **Быстрый**: Высокопроизводительный, на уровне **NodeJS** и **Go** (благодаря Starlette и Pydantic).
    * **Интуитивно понятный**: Отличная поддержка редактора. <dfn title="также известное как автозаполнение, интеллектуальность, автозавершение">Автодополнение кода</dfn> везде. Меньше времени на отладку.
    * **Простой**: Разработан так, чтоб быть простым в использовании и изучении. Меньше времени на чтение документации.
    * **Лаконичный**: Минимизировано повторение кода. Каждый объявленный параметр определяет несколько функций.
    * **Надёжный**: Получите готовый к работе код. С автоматической интерактивной документацией.
    * **Стандартизированный**: Основан на открытых стандартах API (<a href="https://github.com/OAI/OpenAPI-Specification" class="external-link" target="_blank">OpenAPI</a> и <a href="https://json-schema.org/" class="external-link" target="_blank">JSON Schema</a>) и полностью совместим с ними.
    * <a href="https://fastapi.tiangolo.com/features/" class="external-link" target="_blank">**Множество других возможностей**</a> включая автоматическую проверку и сериализацию данных, интерактивную документацию, аутентификацию с помощью OAuth2 JWT-токенов и т.д.
* **Безопасное хранение паролей**, которые хэшируются по умолчанию.
* Аутентификация посредством **JWT-токенов**.
* <dfn title="Python-объекты связанные с базами данных">Модели</dfn>  **SQLAlchemy** (независящие от расширений Flask, а значит могут быть непосредственно использованы процессами Celery).
* Базовая модель пользователя (измените или удалите её по необходимости).
* **Alembic** для организации миграций.
* **CORS** (Совместное использование ресурсов из разных источников).
* **Celery**, процессы которого могут выборочно импортировать и использовать модели и код из остальной части бэкенда.
* Тесты, на основе **Pytest**, интегрированные в Docker, чтобы Вы могли полностью проверить Ваше API, независимо от базы данных. Так как тесты запускаются в Docker, для них может создаваться новое хранилище данных каждый раз (Вы можете, по своему желанию, использовать ElasticSearch, MongoDB, CouchDB или другую СУБД, только лишь для проверки - будет ли Ваше API работать с этим хранилищем).
* Простая интеграция Python с **Jupyter Kernels** для разработки удалённо или в Docker с расширениями похожими на Atom Hydrogen или Visual Studio Code Jupyter.
* Фронтенд построен на фреймворке **Vue**:
    * Сгенерирован с помощью Vue CLI.
    * Поддерживает **аутентификацию с помощью JWT-токенов**.
    * Страница логина.
    * Перенаправление на страницу главной панели мониторинга после логина.
    * Главная страница мониторинга с возможностью создания и изменения пользователей.
    * Пользователь может изменять свои данные.
    * **Vuex**.
    * **Vue-router**.
    * **Vuetify** для конструирования красивых компонентов страниц.
    * **TypeScript**.
    * Сервер Docker основан на **Nginx** (настроен для удобной работы с Vue-router).
    * Многоступенчатая сборка Docker, то есть Вам не нужно сохранять или коммитить скомпилированный код.
    * Тесты фронтенда запускаются во время сборки (можно отключить).
    * Сделан настолько модульно, насколько возможно, поэтому работает "из коробки", но Вы можете повторно сгенерировать фронтенд с помощью Vue CLI или создать то, что Вам нужно и повторно использовать то, что захотите.
* **PGAdmin** для СУБД PostgreSQL, которые легко можно заменить на PHPMyAdmin и MySQL.
* **Flower** для отслеживания работы Celery.
* Балансировка нагрузки между фронтендом и бэкендом с помощью **Traefik**, а значит, Вы можете расположить их на одном домене, разделив url-пути, так как они обслуживаются разными контейнерами.
* Интеграция с Traefik включает автоматическую генерацию сертификатов Let's Encrypt для поддержки протокола **HTTPS**.
* GitLab **CI** (непрерывная интеграция), которая включает тестирование фронтенда и бэкенда.

## Full Stack FastAPI Couchbase

GitHub: <a href="https://github.com/tiangolo/full-stack-fastapi-couchbase" class="external-link" target="_blank">https://github.com/tiangolo/full-stack-fastapi-couchbase</a>

⚠️ **ПРЕДУПРЕЖДЕНИЕ** ⚠️

Если Вы начинаете новый проект, ознакомьтесь с представленными здесь альтернативами.

Например, генератор проектов <a href="https://github.com/tiangolo/full-stack-fastapi-postgresql" class="external-link" target="_blank">Full Stack FastAPI PostgreSQL</a> может быть более подходящей альтернативой, так как он активно поддерживается и используется. И он включает в себя все новые возможности и улучшения.

Но никто не запрещает Вам использовать генератор с СУБД Couchbase, возможно, он всё ещё работает нормально. Или у Вас уже есть проект, созданный с помощью этого генератора ранее, и Вы, вероятно, уже обновили его в соответствии со своими потребностями.

Вы можете прочитать о нём больше в документации соответствующего репозитория.

## Full Stack FastAPI MongoDB

...может быть когда-нибудь появится, в зависимости от наличия у меня свободного времени и прочих факторов. 😅 🎉

## Модели машинного обучения на основе spaCy и FastAPI

GitHub: <a href="https://github.com/microsoft/cookiecutter-spacy-fastapi" class="external-link" target="_blank">https://github.com/microsoft/cookiecutter-spacy-fastapi</a>

### Модели машинного обучения на основе spaCy и FastAPI - Особенности

* Интеграция с моделями **spaCy** NER.
* Встроенный формат запросов к **когнитивному поиску Azure**.
* **Готовый к реальной работе** веб-сервер Python использующий Uvicorn и Gunicorn.
* Встроенное развёртывание на основе **Azure DevOps** Kubernetes (AKS) CI/CD.
* **Многоязычность**. Лёгкий выбор одного из встроенных в spaCy языков во время настройки проекта.
* **Легко подключить** модели из других фреймворков (Pytorch, Tensorflow) не ограничиваясь spaCy.
