/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.orm.jpa.vendor;

import java.util.Map;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import org.hibernate.dialect.DB2Dialect;
import org.hibernate.dialect.HSQLDialect;
import org.hibernate.dialect.InformixDialect;
import org.hibernate.dialect.MySQLDialect;
import org.hibernate.dialect.Oracle9Dialect;
import org.hibernate.dialect.PostgreSQLDialect;
import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.dialect.SybaseDialect;
import org.hibernate.ejb.HibernateEntityManager;
import org.hibernate.ejb.HibernateEntityManagerFactory;
import org.hibernate.ejb.HibernatePersistence;
import org.springframework.orm.jpa.JpaDialect;
import org.springframework.orm.jpa.vendor.AbstractJpaVendorAdapter;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.orm.jpa.vendor.HibernateJpaDialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateJpaVendorAdapter
extends AbstractJpaVendorAdapter {
    private final PersistenceProvider persistenceProvider = new HibernatePersistence();
    private final JpaDialect jpaDialect = new HibernateJpaDialect();

    @Override
    public PersistenceProvider getPersistenceProvider() {
        return this.persistenceProvider;
    }

    @Override
    public String getPersistenceProviderRootPackage() {
        return "org.hibernate";
    }

    @Override
    public Map getJpaPropertyMap() {
        Class databaseDialectClass;
        Properties jpaProperties = new Properties();
        if (this.getDatabasePlatform() != null) {
            jpaProperties.setProperty("hibernate.dialect", this.getDatabasePlatform());
        } else if (this.getDatabase() != null && (databaseDialectClass = this.determineDatabaseDialectClass(this.getDatabase())) != null) {
            jpaProperties.setProperty("hibernate.dialect", databaseDialectClass.getName());
        }
        if (this.isGenerateDdl()) {
            jpaProperties.setProperty("hibernate.hbm2ddl.auto", "update");
        }
        if (this.isShowSql()) {
            jpaProperties.setProperty("hibernate.show_sql", "true");
        }
        return jpaProperties;
    }

    protected Class determineDatabaseDialectClass(Database database) {
        switch (database) {
            case DB2: {
                return DB2Dialect.class;
            }
            case HSQL: {
                return HSQLDialect.class;
            }
            case INFORMIX: {
                return InformixDialect.class;
            }
            case MYSQL: {
                return MySQLDialect.class;
            }
            case ORACLE: {
                return Oracle9Dialect.class;
            }
            case POSTGRESQL: {
                return PostgreSQLDialect.class;
            }
            case SQL_SERVER: {
                return SQLServerDialect.class;
            }
            case SYBASE: {
                return SybaseDialect.class;
            }
        }
        return null;
    }

    @Override
    public JpaDialect getJpaDialect() {
        return this.jpaDialect;
    }

    @Override
    public Class<? extends EntityManagerFactory> getEntityManagerFactoryInterface() {
        return HibernateEntityManagerFactory.class;
    }

    @Override
    public Class<? extends EntityManager> getEntityManagerInterface() {
        return HibernateEntityManager.class;
    }
}

