/*
 * Decompiled with CFR 0.152.
 */
package visad.jmet;

import java.awt.geom.Rectangle2D;
import visad.CoordinateSystem;
import visad.CoordinateSystemException;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;
import visad.georef.MapProjection;

public class EASECoordinateSystem
extends MapProjection {
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    private CoordinateSystem c;
    private double spac;
    private double row0;
    private double col0;
    private double scale;
    private int nrows;
    private int ncols;
    private double R = 6371.228;
    private double cos30;

    public EASECoordinateSystem(double spacing, double row_origin, double column_origin, int number_rows, int number_columns) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
        this.spac = spacing;
        this.scale = this.R / this.spac;
        this.row0 = row_origin;
        this.col0 = column_origin;
        this.nrows = number_rows;
        this.ncols = number_columns;
        this.cos30 = Math.cos(0.5235987755982988);
    }

    public double[][] toReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("EASECoordinateSystem.toReference: tuples wrong dimension");
        }
        double[][] latlon = new double[2][tuples[0].length];
        for (int i = 0; i < tuples[0].length; ++i) {
            latlon[0][i] = -Math.asin((tuples[1][i] - this.row0) * this.cos30 / this.scale) * 57.29577951308232;
            latlon[1][i] = (tuples[0][i] - this.col0) / (this.scale * this.cos30) * 57.29577951308232;
        }
        return latlon;
    }

    public double[][] fromReference(double[][] tuples) throws VisADException {
        if (tuples == null || tuples.length != 2) {
            throw new CoordinateSystemException("EASECoordinateSystem.toReference: tuples wrong dimension");
        }
        double[][] xy = new double[2][tuples[0].length];
        for (int i = 0; i < tuples[0].length; ++i) {
            xy[0][i] = this.col0 + this.scale * tuples[1][i] * (Math.PI / 180) * this.cos30;
            xy[1][i] = this.row0 - this.scale * Math.sin(tuples[0][i] * (Math.PI / 180)) / this.cos30;
        }
        return xy;
    }

    public boolean equals(Object cs) {
        return cs instanceof EASECoordinateSystem;
    }

    public Rectangle2D getDefaultMapArea() {
        return new Rectangle2D.Double(0.0, 0.0, this.ncols, this.nrows);
    }

    public double getAspectRatio() {
        return 1.0;
    }

    public static void main(String[] args) {
        try {
            EASECoordinateSystem nc = new EASECoordinateSystem(3.13344, 1538.0, 3122.0, 721, 721);
            double[][] latlon = new double[2][1];
            double[][] xy = new double[2][1];
            xy[0][0] = 0.0;
            xy[1][0] = 0.0;
            latlon = nc.toReference(xy);
            System.out.println(" (0,0) lat=" + latlon[0][0] + " lon=" + latlon[1][0]);
            xy[0][0] = 720.0;
            xy[1][0] = 720.0;
            latlon = nc.toReference(xy);
            System.out.println(" (720,720) lat=" + latlon[0][0] + " lon=" + latlon[1][0]);
            xy = nc.fromReference(latlon);
            System.out.println(" inverse at above, x=" + xy[0][0] + " y=" + xy[1][0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

