/*
 * ### Copyright (C) 2001-2003 Michael Fuchs ###
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Michael Fuchs
 * E-Mail: mfuchs@unico-consulting.com
 *
 * RCS Information:
 * ---------------
 * Id.........: $Id: TokenizerException.java,v 1.1.1.1 2004/12/21 13:57:02 mfuchs Exp $
 * Author.....: $Author: mfuchs $
 * Date.......: $Date: 2004/12/21 13:57:02 $
 * Revision...: $Revision: 1.1.1.1 $
 * State......: $State: Exp $
 */
package org.dbdoclet.trafo.tokenizer;

public class TokenizerException extends Exception {

    private static final long serialVersionUID = 1L;

    public TokenizerException(String msg) {
        super(msg);
    }

    public TokenizerException(String message, Throwable cause) {
		super(message, cause);
	}

	public TokenizerException(Throwable oops) {
		super(oops);
	}

    @Override
    public String getMessage() {

        String str;
        String msg;

        Throwable cause = getCause();
        
        if (cause != null) {

            msg = "[" + cause.getClass().getName() + "] ";

            str = cause.getMessage();

            if ((str != null) && (str.length() > 0)) {

                msg += str;
            }
        } else {

            msg = super.getMessage();
        }

        return msg;
    }
}

/*
 * $Log: TokenizerException.java,v $
 * Revision 1.1.1.1  2004/12/21 13:57:02  mfuchs
 * Reimport
 *
 * Revision 1.2  2004/10/05 13:11:21  mfuchs
 * Koorektur in der Behandlung von Entitäten
 *
 * Revision 1.1.1.1  2004/07/29 14:49:43  mfuchs
 * Tagspender
 *
 * Revision 1.1.1.1  2004/02/17 22:51:06  mfuchs
 * dbdoclet
 *
 * Revision 1.1.1.1  2004/01/05 14:58:45  cvs
 * dbdoclet
 *
 * Revision 1.1.1.1  2003/08/01 13:17:52  cvs
 * DocBook Doclet
 *
 * Revision 1.1.1.1  2003/07/31 17:05:39  mfuchs
 * DocBook Doclet since 0.46
 *
 * Revision 1.1.1.1  2003/05/30 11:09:40  mfuchs
 * dbdoclet
 *
 * Revision 1.1.1.1  2003/03/18 07:41:37  mfuchs
 * DocBook Doclet 0.40
 *
 * Revision 1.1.1.1  2003/03/17 20:50:12  cvs
 * dbdoclet
 *
 */
