/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcActor.h"
#include "ifcpp/IFC4/include/IfcActorRole.h"
#include "ifcpp/IFC4/include/IfcGloballyUniqueId.h"
#include "ifcpp/IFC4/include/IfcLabel.h"
#include "ifcpp/IFC4/include/IfcObjectDefinition.h"
#include "ifcpp/IFC4/include/IfcObjectTypeEnum.h"
#include "ifcpp/IFC4/include/IfcOwnerHistory.h"
#include "ifcpp/IFC4/include/IfcRelAssignsToActor.h"
#include "ifcpp/IFC4/include/IfcText.h"

// ENTITY IfcRelAssignsToActor 
IfcRelAssignsToActor::IfcRelAssignsToActor( int id ) { m_entity_id = id; }
IfcRelAssignsToActor::~IfcRelAssignsToActor() {}
shared_ptr<BuildingObject> IfcRelAssignsToActor::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcRelAssignsToActor> copy_self( new IfcRelAssignsToActor() );
	if( m_GlobalId )
	{
		if( options.create_new_IfcGloballyUniqueId ) { copy_self->m_GlobalId = make_shared<IfcGloballyUniqueId>( createBase64Uuid<wchar_t>().data() ); }
		else { copy_self->m_GlobalId = dynamic_pointer_cast<IfcGloballyUniqueId>( m_GlobalId->getDeepCopy(options) ); }
	}
	if( m_OwnerHistory )
	{
		if( options.shallow_copy_IfcOwnerHistory ) { copy_self->m_OwnerHistory = m_OwnerHistory; }
		else { copy_self->m_OwnerHistory = dynamic_pointer_cast<IfcOwnerHistory>( m_OwnerHistory->getDeepCopy(options) ); }
	}
	if( m_Name ) { copy_self->m_Name = dynamic_pointer_cast<IfcLabel>( m_Name->getDeepCopy(options) ); }
	if( m_Description ) { copy_self->m_Description = dynamic_pointer_cast<IfcText>( m_Description->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_RelatedObjects.size(); ++ii )
	{
		auto item_ii = m_RelatedObjects[ii];
		if( item_ii )
		{
			copy_self->m_RelatedObjects.emplace_back( dynamic_pointer_cast<IfcObjectDefinition>(item_ii->getDeepCopy(options) ) );
		}
	}
	if( m_RelatedObjectsType ) { copy_self->m_RelatedObjectsType = dynamic_pointer_cast<IfcObjectTypeEnum>( m_RelatedObjectsType->getDeepCopy(options) ); }
	if( m_RelatingActor ) { copy_self->m_RelatingActor = dynamic_pointer_cast<IfcActor>( m_RelatingActor->getDeepCopy(options) ); }
	if( m_ActingRole ) { copy_self->m_ActingRole = dynamic_pointer_cast<IfcActorRole>( m_ActingRole->getDeepCopy(options) ); }
	return copy_self;
}
void IfcRelAssignsToActor::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCRELASSIGNSTOACTOR" << "(";
	if( m_GlobalId ) { m_GlobalId->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_OwnerHistory ) { stream << "#" << m_OwnerHistory->m_entity_id; } else { stream << "$"; }
	stream << ",";
	if( m_Name ) { m_Name->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Description ) { m_Description->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	writeEntityList( stream, m_RelatedObjects );
	stream << ",";
	if( m_RelatedObjectsType ) { m_RelatedObjectsType->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_RelatingActor ) { stream << "#" << m_RelatingActor->m_entity_id; } else { stream << "$"; }
	stream << ",";
	if( m_ActingRole ) { stream << "#" << m_ActingRole->m_entity_id; } else { stream << "$"; }
	stream << ");";
}
void IfcRelAssignsToActor::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcRelAssignsToActor::toString() const { return L"IfcRelAssignsToActor"; }
void IfcRelAssignsToActor::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 8 ){ std::stringstream err; err << "Wrong parameter count for entity IfcRelAssignsToActor, expecting 8, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	m_GlobalId = IfcGloballyUniqueId::createObjectFromSTEP( args[0], map );
	readEntityReference( args[1], m_OwnerHistory, map );
	m_Name = IfcLabel::createObjectFromSTEP( args[2], map );
	m_Description = IfcText::createObjectFromSTEP( args[3], map );
	readEntityReferenceList( args[4], m_RelatedObjects, map );
	m_RelatedObjectsType = IfcObjectTypeEnum::createObjectFromSTEP( args[5], map );
	readEntityReference( args[6], m_RelatingActor, map );
	readEntityReference( args[7], m_ActingRole, map );
}
void IfcRelAssignsToActor::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcRelAssigns::getAttributes( vec_attributes );
	vec_attributes.emplace_back( std::make_pair( "RelatingActor", m_RelatingActor ) );
	vec_attributes.emplace_back( std::make_pair( "ActingRole", m_ActingRole ) );
}
void IfcRelAssignsToActor::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcRelAssigns::getAttributesInverse( vec_attributes_inverse );
}
void IfcRelAssignsToActor::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcRelAssigns::setInverseCounterparts( ptr_self_entity );
	shared_ptr<IfcRelAssignsToActor> ptr_self = dynamic_pointer_cast<IfcRelAssignsToActor>( ptr_self_entity );
	if( !ptr_self ) { throw BuildingException( "IfcRelAssignsToActor::setInverseCounterparts: type mismatch" ); }
	if( m_RelatingActor )
	{
		m_RelatingActor->m_IsActingUpon_inverse.emplace_back( ptr_self );
	}
}
void IfcRelAssignsToActor::unlinkFromInverseCounterparts()
{
	IfcRelAssigns::unlinkFromInverseCounterparts();
	if( m_RelatingActor )
	{
		std::vector<weak_ptr<IfcRelAssignsToActor> >& IsActingUpon_inverse = m_RelatingActor->m_IsActingUpon_inverse;
		for( auto it_IsActingUpon_inverse = IsActingUpon_inverse.begin(); it_IsActingUpon_inverse != IsActingUpon_inverse.end(); )
		{
			weak_ptr<IfcRelAssignsToActor> self_candidate_weak = *it_IsActingUpon_inverse;
			if( self_candidate_weak.expired() )
			{
				++it_IsActingUpon_inverse;
				continue;
			}
			shared_ptr<IfcRelAssignsToActor> self_candidate( *it_IsActingUpon_inverse );
			if( self_candidate.get() == this )
			{
				it_IsActingUpon_inverse= IsActingUpon_inverse.erase( it_IsActingUpon_inverse );
			}
			else
			{
				++it_IsActingUpon_inverse;
			}
		}
	}
}
