/* Code generated by IfcQuery EXPRESS generator, www.ifcquery.com */
#include <sstream>
#include <limits>

#include "ifcpp/model/AttributeObject.h"
#include "ifcpp/model/BuildingException.h"
#include "ifcpp/model/BuildingGuid.h"
#include "ifcpp/reader/ReaderUtil.h"
#include "ifcpp/writer/WriterUtil.h"
#include "ifcpp/IFC4/include/IfcAddressTypeEnum.h"
#include "ifcpp/IFC4/include/IfcLabel.h"
#include "ifcpp/IFC4/include/IfcOrganization.h"
#include "ifcpp/IFC4/include/IfcPerson.h"
#include "ifcpp/IFC4/include/IfcTelecomAddress.h"
#include "ifcpp/IFC4/include/IfcText.h"
#include "ifcpp/IFC4/include/IfcURIReference.h"

// ENTITY IfcTelecomAddress 
IfcTelecomAddress::IfcTelecomAddress( int id ) { m_entity_id = id; }
IfcTelecomAddress::~IfcTelecomAddress() {}
shared_ptr<BuildingObject> IfcTelecomAddress::getDeepCopy( BuildingCopyOptions& options )
{
	shared_ptr<IfcTelecomAddress> copy_self( new IfcTelecomAddress() );
	if( m_Purpose ) { copy_self->m_Purpose = dynamic_pointer_cast<IfcAddressTypeEnum>( m_Purpose->getDeepCopy(options) ); }
	if( m_Description ) { copy_self->m_Description = dynamic_pointer_cast<IfcText>( m_Description->getDeepCopy(options) ); }
	if( m_UserDefinedPurpose ) { copy_self->m_UserDefinedPurpose = dynamic_pointer_cast<IfcLabel>( m_UserDefinedPurpose->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_TelephoneNumbers.size(); ++ii )
	{
		auto item_ii = m_TelephoneNumbers[ii];
		if( item_ii )
		{
			copy_self->m_TelephoneNumbers.emplace_back( dynamic_pointer_cast<IfcLabel>(item_ii->getDeepCopy(options) ) );
		}
	}
	for( size_t ii=0; ii<m_FacsimileNumbers.size(); ++ii )
	{
		auto item_ii = m_FacsimileNumbers[ii];
		if( item_ii )
		{
			copy_self->m_FacsimileNumbers.emplace_back( dynamic_pointer_cast<IfcLabel>(item_ii->getDeepCopy(options) ) );
		}
	}
	if( m_PagerNumber ) { copy_self->m_PagerNumber = dynamic_pointer_cast<IfcLabel>( m_PagerNumber->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_ElectronicMailAddresses.size(); ++ii )
	{
		auto item_ii = m_ElectronicMailAddresses[ii];
		if( item_ii )
		{
			copy_self->m_ElectronicMailAddresses.emplace_back( dynamic_pointer_cast<IfcLabel>(item_ii->getDeepCopy(options) ) );
		}
	}
	if( m_WWWHomePageURL ) { copy_self->m_WWWHomePageURL = dynamic_pointer_cast<IfcURIReference>( m_WWWHomePageURL->getDeepCopy(options) ); }
	for( size_t ii=0; ii<m_MessagingIDs.size(); ++ii )
	{
		auto item_ii = m_MessagingIDs[ii];
		if( item_ii )
		{
			copy_self->m_MessagingIDs.emplace_back( dynamic_pointer_cast<IfcURIReference>(item_ii->getDeepCopy(options) ) );
		}
	}
	return copy_self;
}
void IfcTelecomAddress::getStepLine( std::stringstream& stream ) const
{
	stream << "#" << m_entity_id << "= IFCTELECOMADDRESS" << "(";
	if( m_Purpose ) { m_Purpose->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_Description ) { m_Description->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	if( m_UserDefinedPurpose ) { m_UserDefinedPurpose->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	stream << "(";
	for( size_t ii = 0; ii < m_TelephoneNumbers.size(); ++ii )
	{
		if( ii > 0 )
		{
			stream << ",";
		}
		const shared_ptr<IfcLabel>& type_object = m_TelephoneNumbers[ii];
		if( type_object )
		{
			type_object->getStepParameter( stream, false );
		}
		else
		{
			stream << "$";
		}
	}
	stream << ")";
	stream << ",";
	stream << "(";
	for( size_t ii = 0; ii < m_FacsimileNumbers.size(); ++ii )
	{
		if( ii > 0 )
		{
			stream << ",";
		}
		const shared_ptr<IfcLabel>& type_object = m_FacsimileNumbers[ii];
		if( type_object )
		{
			type_object->getStepParameter( stream, false );
		}
		else
		{
			stream << "$";
		}
	}
	stream << ")";
	stream << ",";
	if( m_PagerNumber ) { m_PagerNumber->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	stream << "(";
	for( size_t ii = 0; ii < m_ElectronicMailAddresses.size(); ++ii )
	{
		if( ii > 0 )
		{
			stream << ",";
		}
		const shared_ptr<IfcLabel>& type_object = m_ElectronicMailAddresses[ii];
		if( type_object )
		{
			type_object->getStepParameter( stream, false );
		}
		else
		{
			stream << "$";
		}
	}
	stream << ")";
	stream << ",";
	if( m_WWWHomePageURL ) { m_WWWHomePageURL->getStepParameter( stream ); } else { stream << "$"; }
	stream << ",";
	stream << "(";
	for( size_t ii = 0; ii < m_MessagingIDs.size(); ++ii )
	{
		if( ii > 0 )
		{
			stream << ",";
		}
		const shared_ptr<IfcURIReference>& type_object = m_MessagingIDs[ii];
		if( type_object )
		{
			type_object->getStepParameter( stream, false );
		}
		else
		{
			stream << "$";
		}
	}
	stream << ")";
	stream << ");";
}
void IfcTelecomAddress::getStepParameter( std::stringstream& stream, bool ) const { stream << "#" << m_entity_id; }
const std::wstring IfcTelecomAddress::toString() const { return L"IfcTelecomAddress"; }
void IfcTelecomAddress::readStepArguments( const std::vector<std::wstring>& args, const std::map<int,shared_ptr<BuildingEntity> >& map )
{
	const size_t num_args = args.size();
	if( num_args != 9 ){ std::stringstream err; err << "Wrong parameter count for entity IfcTelecomAddress, expecting 9, having " << num_args << ". Entity ID: " << m_entity_id << std::endl; throw BuildingException( err.str().c_str() ); }
	m_Purpose = IfcAddressTypeEnum::createObjectFromSTEP( args[0], map );
	m_Description = IfcText::createObjectFromSTEP( args[1], map );
	m_UserDefinedPurpose = IfcLabel::createObjectFromSTEP( args[2], map );
	readTypeOfStringList( args[3], m_TelephoneNumbers );
	readTypeOfStringList( args[4], m_FacsimileNumbers );
	m_PagerNumber = IfcLabel::createObjectFromSTEP( args[5], map );
	readTypeOfStringList( args[6], m_ElectronicMailAddresses );
	m_WWWHomePageURL = IfcURIReference::createObjectFromSTEP( args[7], map );
	readTypeOfStringList( args[8], m_MessagingIDs );
}
void IfcTelecomAddress::getAttributes( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes ) const
{
	IfcAddress::getAttributes( vec_attributes );
	if( !m_TelephoneNumbers.empty() )
	{
		shared_ptr<AttributeObjectVector> TelephoneNumbers_vec_object( new AttributeObjectVector() );
		std::copy( m_TelephoneNumbers.begin(), m_TelephoneNumbers.end(), std::back_inserter( TelephoneNumbers_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "TelephoneNumbers", TelephoneNumbers_vec_object ) );
	}
	if( !m_FacsimileNumbers.empty() )
	{
		shared_ptr<AttributeObjectVector> FacsimileNumbers_vec_object( new AttributeObjectVector() );
		std::copy( m_FacsimileNumbers.begin(), m_FacsimileNumbers.end(), std::back_inserter( FacsimileNumbers_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "FacsimileNumbers", FacsimileNumbers_vec_object ) );
	}
	vec_attributes.emplace_back( std::make_pair( "PagerNumber", m_PagerNumber ) );
	if( !m_ElectronicMailAddresses.empty() )
	{
		shared_ptr<AttributeObjectVector> ElectronicMailAddresses_vec_object( new AttributeObjectVector() );
		std::copy( m_ElectronicMailAddresses.begin(), m_ElectronicMailAddresses.end(), std::back_inserter( ElectronicMailAddresses_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "ElectronicMailAddresses", ElectronicMailAddresses_vec_object ) );
	}
	vec_attributes.emplace_back( std::make_pair( "WWWHomePageURL", m_WWWHomePageURL ) );
	if( !m_MessagingIDs.empty() )
	{
		shared_ptr<AttributeObjectVector> MessagingIDs_vec_object( new AttributeObjectVector() );
		std::copy( m_MessagingIDs.begin(), m_MessagingIDs.end(), std::back_inserter( MessagingIDs_vec_object->m_vec ) );
		vec_attributes.emplace_back( std::make_pair( "MessagingIDs", MessagingIDs_vec_object ) );
	}
}
void IfcTelecomAddress::getAttributesInverse( std::vector<std::pair<std::string, shared_ptr<BuildingObject> > >& vec_attributes_inverse ) const
{
	IfcAddress::getAttributesInverse( vec_attributes_inverse );
}
void IfcTelecomAddress::setInverseCounterparts( shared_ptr<BuildingEntity> ptr_self_entity )
{
	IfcAddress::setInverseCounterparts( ptr_self_entity );
}
void IfcTelecomAddress::unlinkFromInverseCounterparts()
{
	IfcAddress::unlinkFromInverseCounterparts();
}
