/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

struct filterplugininfo
{
	std::string pluginname;
};

typedef bool (*initfilterplugintype)(struct filterplugininfo &filterplugininfo,
	class Options &options, bool debugmode);
typedef void (*closefilterplugintype)(void);
typedef bool (*filtertype)(char *originalbuffer, char *modifiedbuffer, struct imevent &imevent);

class FilterPlugin
{
	public:
		struct filterplugininfo filterplugininfo;
		
		FilterPlugin();
		~FilterPlugin();
		bool loadplugin(std::string filename);
		bool unloadplugin(void);
		
		bool callinitfilterplugin(class Options &options, bool debugmode);
		void callclosefilterplugin(void);
		bool callfilter(char *originalbuffer, char *modifiedbuffer, struct imevent &imevent);

	private:
		void *handle;

		initfilterplugintype initfilterplugin;
		closefilterplugintype closefilterplugin;
		filtertype filter;
};

