/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2006, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package javax.resource.cci;

import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * The Streamable interface allows a resource adapter to interact with a Record
 * as a stream of bytes.
 * 
 * The Streamable interface is used by a resource adapter.
 */
public interface Streamable
{
   /**
	 * Read the Streamable from the specified InputStream.
	 */
   public void read(InputStream istream) throws IOException;

   /**
	 * Write the Streamable to the specified OutputStream.
	 */
   public void write(OutputStream ostream) throws IOException;
}