/*
 ***** BEGIN LICENSE BLOCK *****
 * Version: EPL 2.0/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Eclipse Public
 * License Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of
 * the License at http://www.eclipse.org/legal/epl-v20.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 * Copyright (C) 2011 Nick Sieger <nicksieger@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either of the GNU General Public License Version 2 or later (the "GPL"),
 * or the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the EPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the EPL, the GPL or the LGPL.
 ***** END LICENSE BLOCK *****/

package org.jruby.util;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

/**
 * All this because URL.getPath sucks, and we can't re-open classes in Java ;-).
 *
 * See also:
 * http://weblogs.java.net/blog/2007/04/25/how-convert-javaneturl-javaiofile
 * http://stackoverflow.com/questions/18520972/converting-java-file-url-to-file-path-platform-independent-including-u
 */
public class URLUtil {
    public static String getPath(URL url) {
        try {
            return url.toURI().getSchemeSpecificPart();
        } catch (URISyntaxException use) {
            return url.getPath();
        }
    }

    public static String getPlatformPath(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
       // the getPath from File uses the platform name-separator
       return new File(getPath(url)).getPath();
    }
}
