#ifndef _GFile_DC120_H
#define _GFile_DC120_H

/* Class used to handle processing of .kdc file from KDCFile.
 * 
 * Written by:  Chris Studholme
 * Last Update: 8-January-2000
 * Copyright:   GPL (http://www.fsf.org/copyleft/gpl.html)
 */

#include "GFile.h"
#include "KDCFile.h"


class GFile_DC120 : public GFile {

 protected:
  int w, h;
  double aspect;
  unsigned int histogram[256];

 public:
  GFile_DC120(KDCFile& file, bool fast=false);
  virtual ~GFile_DC120();

  static bool supportsFile(FILE* file);

  bool isOK() {
    return true;
  }

  void FindBestMinMax(int& min, int& max) {
    calculateBestMinMax(min,max,histogram);
  }

  int getWidth() {
    return w;
  }
  int getHeight() {
    return h;
  }
  int getPreferredWidth() {
    return 1200;
  }
  int getPreferredHeight() {
    return 900;
  }
  double getAspectRatio() {
    return aspect;
  }

  const char* getComments() {
    return NULL;
  }

  void getPixel(short& r, short& g, short& b,
		float x1, float y1, float x2, float y2) {
    r = red->getPixel(x1,y1,x2,y2);
    g = green->getPixel(x1,y1,x2,y2);
    b = blue->getPixel(x1,y1,x2,y2);
  }
  void getScanLineHorz(short* r, short* g, short* b,
		       float x1, float y1, float x2, float y2, int npixels) {
    red->getScanLineHorz(r,x1,y1,x2,y2,npixels);
    green->getScanLineHorz(g,x1,y1,x2,y2,npixels);
    blue->getScanLineHorz(b,x1,y1,x2,y2,npixels);
  }
  void getScanLineVert(short* r, short* g, short* b,
		       float x1, float y1, float x2, float y2, int npixels) {
    red->getScanLineVert(r,x1,y1,x2,y2,npixels);
    green->getScanLineVert(g,x1,y1,x2,y2,npixels);
    blue->getScanLineVert(b,x1,y1,x2,y2,npixels);
  }

};

#endif
