
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQFormLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QFormLayout>
#include <QChildEvent>
#include <QEvent>
#include <QLayout>
#include <QLayoutItem>
#include <QMargins>
#include <QMetaMethod>
#include <QObject>
#include <QRect>
#include <QSize>
#include <QSpacerItem>
#include <QThread>
#include <QTimerEvent>
#include <QWidget>
#include "gsiQt.h"
#include "gsiQtWidgetsCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QFormLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QFormLayout::staticMetaObject);
}


// void QFormLayout::addItem(QLayoutItem *item)


static void _init_f_addItem_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1740 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayoutItem *arg1 = gsi::arg_reader<QLayoutItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->addItem (arg1);
}


// void QFormLayout::addRow(QWidget *label, QWidget *field)


static void _init_f_addRow_2522 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_2522 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg2);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}


// void QFormLayout::addRow(QWidget *label, QLayout *field)


static void _init_f_addRow_2548 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("label");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QLayout * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_2548 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  QLayout *arg2 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg2);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}


// void QFormLayout::addRow(const QString &labelText, QWidget *field)


static void _init_f_addRow_3232 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labelText");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_3232 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg2);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}


// void QFormLayout::addRow(const QString &labelText, QLayout *field)


static void _init_f_addRow_3258 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("labelText");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("field");
  decl->add_arg<QLayout * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addRow_3258 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  QLayout *arg2 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg2);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->addRow (arg1, arg2);
}


// void QFormLayout::addRow(QWidget *widget)


static void _init_f_addRow_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addRow_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->addRow (arg1);
}


// void QFormLayout::addRow(QLayout *layout)


static void _init_f_addRow_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addRow_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->addRow (arg1);
}


// int QFormLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFormLayout *)cls)->count ());
}


// QFlags<Qt::Orientation> QFormLayout::expandingDirections()


static void _init_f_expandingDirections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::Orientation> > ();
}

static void _call_f_expandingDirections_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::Orientation> > ((QFlags<Qt::Orientation>)((QFormLayout *)cls)->expandingDirections ());
}


// QFormLayout::FieldGrowthPolicy QFormLayout::fieldGrowthPolicy()


static void _init_f_fieldGrowthPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type > ();
}

static void _call_f_fieldGrowthPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type > ((qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type)qt_gsi::CppToQtAdaptor<QFormLayout::FieldGrowthPolicy>(((QFormLayout *)cls)->fieldGrowthPolicy ()));
}


// QFlags<Qt::AlignmentFlag> QFormLayout::formAlignment()


static void _init_f_formAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_formAlignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QFormLayout *)cls)->formAlignment ());
}


// void QFormLayout::getItemPosition(int index, int *rowPtr, QFormLayout::ItemRole *rolePtr)


static void _init_f_getItemPosition_c4166 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rowPtr");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rolePtr");
  decl->add_arg<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getItemPosition_c4166 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  qt_gsi::Converter<QFormLayout::ItemRole>::target_type * arg3 = gsi::arg_reader<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->getItemPosition (arg1, arg2, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg3).ptr());
}


// void QFormLayout::getLayoutPosition(QLayout *layout, int *rowPtr, QFormLayout::ItemRole *rolePtr)


static void _init_f_getLayoutPosition_c4740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rowPtr");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rolePtr");
  decl->add_arg<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getLayoutPosition_c4740 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  qt_gsi::Converter<QFormLayout::ItemRole>::target_type * arg3 = gsi::arg_reader<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->getLayoutPosition (arg1, arg2, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg3).ptr());
}


// void QFormLayout::getWidgetPosition(QWidget *widget, int *rowPtr, QFormLayout::ItemRole *rolePtr)


static void _init_f_getWidgetPosition_c4714 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("rowPtr");
  decl->add_arg<int * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("rolePtr");
  decl->add_arg<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_getWidgetPosition_c4714 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  int *arg2 = gsi::arg_reader<int * >() (args, heap);
  qt_gsi::Converter<QFormLayout::ItemRole>::target_type * arg3 = gsi::arg_reader<qt_gsi::Converter<QFormLayout::ItemRole>::target_type * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->getWidgetPosition (arg1, arg2, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg3).ptr());
}


// bool QFormLayout::hasHeightForWidth()


static void _init_f_hasHeightForWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasHeightForWidth_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFormLayout *)cls)->hasHeightForWidth ());
}


// int QFormLayout::heightForWidth(int width)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<int > ((int)((QFormLayout *)cls)->heightForWidth (arg1));
}


// int QFormLayout::horizontalSpacing()


static void _init_f_horizontalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_horizontalSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFormLayout *)cls)->horizontalSpacing ());
}


// void QFormLayout::insertRow(int row, QWidget *label, QWidget *field)


static void _init_f_insertRow_3181 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("label");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3181 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  QWidget *arg3 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg3);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}


// void QFormLayout::insertRow(int row, QWidget *label, QLayout *field)


static void _init_f_insertRow_3207 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("label");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QLayout * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3207 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  QLayout *arg3 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg3);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}


// void QFormLayout::insertRow(int row, const QString &labelText, QWidget *field)


static void _init_f_insertRow_3891 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("labelText");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3891 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QWidget *arg3 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg3);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}


// void QFormLayout::insertRow(int row, const QString &labelText, QLayout *field)


static void _init_f_insertRow_3917 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("labelText");
  decl->add_arg<const QString & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("field");
  decl->add_arg<QLayout * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertRow_3917 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const QString &arg2 = gsi::arg_reader<const QString & >() (args, heap);
  QLayout *arg3 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg3);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->insertRow (arg1, arg2, arg3);
}


// void QFormLayout::insertRow(int row, QWidget *widget)


static void _init_f_insertRow_1974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_1974 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QWidget *arg2 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->insertRow (arg1, arg2);
}


// void QFormLayout::insertRow(int row, QLayout *layout)


static void _init_f_insertRow_2000 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layout");
  decl->add_arg<QLayout * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertRow_2000 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  QLayout *arg2 = gsi::arg_reader<QLayout * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->insertRow (arg1, arg2);
}


// void QFormLayout::invalidate()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->invalidate ();
}


// QLayoutItem *QFormLayout::itemAt(int row, QFormLayout::ItemRole role)


static void _init_f_itemAt_c3135 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c3135 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout *)cls)->itemAt (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref()));
}


// QLayoutItem *QFormLayout::itemAt(int index)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout *)cls)->itemAt (arg1));
}


// QFlags<Qt::AlignmentFlag> QFormLayout::labelAlignment()


static void _init_f_labelAlignment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::AlignmentFlag> > ();
}

static void _call_f_labelAlignment_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::AlignmentFlag> > ((QFlags<Qt::AlignmentFlag>)((QFormLayout *)cls)->labelAlignment ());
}


// QWidget *QFormLayout::labelForField(QWidget *field)


static void _init_f_labelForField_c1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_labelForField_c1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QFormLayout *)cls)->labelForField (arg1));
}


// QWidget *QFormLayout::labelForField(QLayout *field)


static void _init_f_labelForField_c1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("field");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_labelForField_c1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  ret.write<QWidget * > ((QWidget *)((QFormLayout *)cls)->labelForField (arg1));
}


// QSize QFormLayout::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFormLayout *)cls)->minimumSize ());
}


// void QFormLayout::removeRow(int row)


static void _init_f_removeRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->removeRow (arg1);
}


// void QFormLayout::removeRow(QWidget *widget)


static void _init_f_removeRow_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeRow_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->removeRow (arg1);
}


// void QFormLayout::removeRow(QLayout *layout)


static void _init_f_removeRow_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_removeRow_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->removeRow (arg1);
}


// int QFormLayout::rowCount()


static void _init_f_rowCount_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_rowCount_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFormLayout *)cls)->rowCount ());
}


// QFormLayout::RowWrapPolicy QFormLayout::rowWrapPolicy()


static void _init_f_rowWrapPolicy_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type > ();
}

static void _call_f_rowWrapPolicy_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type > ((qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type)qt_gsi::CppToQtAdaptor<QFormLayout::RowWrapPolicy>(((QFormLayout *)cls)->rowWrapPolicy ()));
}


// void QFormLayout::setFieldGrowthPolicy(QFormLayout::FieldGrowthPolicy policy)


static void _init_f_setFieldGrowthPolicy_3418 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFieldGrowthPolicy_3418 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFormLayout::FieldGrowthPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setFieldGrowthPolicy (qt_gsi::QtToCppAdaptor<QFormLayout::FieldGrowthPolicy>(arg1).cref());
}


// void QFormLayout::setFormAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setFormAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormAlignment_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setFormAlignment (arg1);
}


// void QFormLayout::setGeometry(const QRect &rect)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setGeometry (arg1);
}


// void QFormLayout::setHorizontalSpacing(int spacing)


static void _init_f_setHorizontalSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setHorizontalSpacing_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setHorizontalSpacing (arg1);
}


// void QFormLayout::setItem(int row, QFormLayout::ItemRole role, QLayoutItem *item)


static void _init_f_setItem_4767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("item");
  decl->add_arg<QLayoutItem * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setItem_4767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & >() (args, heap);
  QLayoutItem *arg3 = gsi::arg_reader<QLayoutItem * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setItem (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref(), arg3);
}


// void QFormLayout::setLabelAlignment(QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_setLabelAlignment_2750 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("alignment");
  decl->add_arg<QFlags<Qt::AlignmentFlag> > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLabelAlignment_2750 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QFlags<Qt::AlignmentFlag> arg1 = gsi::arg_reader<QFlags<Qt::AlignmentFlag> >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setLabelAlignment (arg1);
}


// void QFormLayout::setLayout(int row, QFormLayout::ItemRole role, QLayout *layout)


static void _init_f_setLayout_4368 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("layout");
  decl->add_arg<QLayout * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setLayout_4368 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & >() (args, heap);
  QLayout *arg3 = gsi::arg_reader<QLayout * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setLayout (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref(), arg3);
}


// void QFormLayout::setRowWrapPolicy(QFormLayout::RowWrapPolicy policy)


static void _init_f_setRowWrapPolicy_3021 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("policy");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRowWrapPolicy_3021 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QFormLayout::RowWrapPolicy>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setRowWrapPolicy (qt_gsi::QtToCppAdaptor<QFormLayout::RowWrapPolicy>(arg1).cref());
}


// void QFormLayout::setSpacing(int)


static void _init_f_setSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpacing_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setSpacing (arg1);
}


// void QFormLayout::setVerticalSpacing(int spacing)


static void _init_f_setVerticalSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVerticalSpacing_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setVerticalSpacing (arg1);
}


// void QFormLayout::setWidget(int row, QFormLayout::ItemRole role, QWidget *widget)


static void _init_f_setWidget_4342 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("role");
  decl->add_arg<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("widget");
  decl->add_arg<QWidget * > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_setWidget_4342 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & arg2 = gsi::arg_reader<const qt_gsi::Converter<QFormLayout::ItemRole>::target_type & >() (args, heap);
  QWidget *arg3 = gsi::arg_reader<QWidget * >() (args, heap);
  qt_gsi::qt_keep (arg3);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout *)cls)->setWidget (arg1, qt_gsi::QtToCppAdaptor<QFormLayout::ItemRole>(arg2).cref(), arg3);
}


// QSize QFormLayout::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFormLayout *)cls)->sizeHint ());
}


// int QFormLayout::spacing()


static void _init_f_spacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_spacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFormLayout *)cls)->spacing ());
}


// QLayoutItem *QFormLayout::takeAt(int index)


static void _init_f_takeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_takeAt_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout *)cls)->takeAt (arg1));
}


// QFormLayout::TakeRowResult QFormLayout::takeRow(int row)


static void _init_f_takeRow_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("row");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QFormLayout::TakeRowResult > ();
}

static void _call_f_takeRow_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  ret.write<QFormLayout::TakeRowResult > ((QFormLayout::TakeRowResult)((QFormLayout *)cls)->takeRow (arg1));
}


// QFormLayout::TakeRowResult QFormLayout::takeRow(QWidget *widget)


static void _init_f_takeRow_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<QFormLayout::TakeRowResult > ();
}

static void _call_f_takeRow_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  ret.write<QFormLayout::TakeRowResult > ((QFormLayout::TakeRowResult)((QFormLayout *)cls)->takeRow (arg1));
}


// QFormLayout::TakeRowResult QFormLayout::takeRow(QLayout *layout)


static void _init_f_takeRow_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<QFormLayout::TakeRowResult > ();
}

static void _call_f_takeRow_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  ret.write<QFormLayout::TakeRowResult > ((QFormLayout::TakeRowResult)((QFormLayout *)cls)->takeRow (arg1));
}


// int QFormLayout::verticalSpacing()


static void _init_f_verticalSpacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_verticalSpacing_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFormLayout *)cls)->verticalSpacing ());
}


// static QString QFormLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QFormLayout::tr (arg1, arg2, arg3));
}


// static QString QFormLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QFormLayout::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QFormLayout () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Method void QFormLayout::addItem(QLayoutItem *item)\nThis is a reimplementation of QLayout::addItem", false, &_init_f_addItem_1740, &_call_f_addItem_1740);
  methods += new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QWidget *label, QWidget *field)\n", false, &_init_f_addRow_2522, &_call_f_addRow_2522);
  methods += new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QWidget *label, QLayout *field)\n", false, &_init_f_addRow_2548, &_call_f_addRow_2548);
  methods += new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(const QString &labelText, QWidget *field)\n", false, &_init_f_addRow_3232, &_call_f_addRow_3232);
  methods += new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(const QString &labelText, QLayout *field)\n", false, &_init_f_addRow_3258, &_call_f_addRow_3258);
  methods += new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QWidget *widget)\n", false, &_init_f_addRow_1315, &_call_f_addRow_1315);
  methods += new qt_gsi::GenericMethod ("addRow", "@brief Method void QFormLayout::addRow(QLayout *layout)\n", false, &_init_f_addRow_1341, &_call_f_addRow_1341);
  methods += new qt_gsi::GenericMethod ("count", "@brief Method int QFormLayout::count()\nThis is a reimplementation of QLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@brief Method QFlags<Qt::Orientation> QFormLayout::expandingDirections()\nThis is a reimplementation of QLayout::expandingDirections", true, &_init_f_expandingDirections_c0, &_call_f_expandingDirections_c0);
  methods += new qt_gsi::GenericMethod (":fieldGrowthPolicy", "@brief Method QFormLayout::FieldGrowthPolicy QFormLayout::fieldGrowthPolicy()\n", true, &_init_f_fieldGrowthPolicy_c0, &_call_f_fieldGrowthPolicy_c0);
  methods += new qt_gsi::GenericMethod (":formAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QFormLayout::formAlignment()\n", true, &_init_f_formAlignment_c0, &_call_f_formAlignment_c0);
  methods += new qt_gsi::GenericMethod ("getItemPosition", "@brief Method void QFormLayout::getItemPosition(int index, int *rowPtr, QFormLayout::ItemRole *rolePtr)\n", true, &_init_f_getItemPosition_c4166, &_call_f_getItemPosition_c4166);
  methods += new qt_gsi::GenericMethod ("getLayoutPosition", "@brief Method void QFormLayout::getLayoutPosition(QLayout *layout, int *rowPtr, QFormLayout::ItemRole *rolePtr)\n", true, &_init_f_getLayoutPosition_c4740, &_call_f_getLayoutPosition_c4740);
  methods += new qt_gsi::GenericMethod ("getWidgetPosition", "@brief Method void QFormLayout::getWidgetPosition(QWidget *widget, int *rowPtr, QFormLayout::ItemRole *rolePtr)\n", true, &_init_f_getWidgetPosition_c4714, &_call_f_getWidgetPosition_c4714);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Method bool QFormLayout::hasHeightForWidth()\nThis is a reimplementation of QLayoutItem::hasHeightForWidth", true, &_init_f_hasHeightForWidth_c0, &_call_f_hasHeightForWidth_c0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QFormLayout::heightForWidth(int width)\nThis is a reimplementation of QLayoutItem::heightForWidth", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
  methods += new qt_gsi::GenericMethod (":horizontalSpacing", "@brief Method int QFormLayout::horizontalSpacing()\n", true, &_init_f_horizontalSpacing_c0, &_call_f_horizontalSpacing_c0);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QWidget *label, QWidget *field)\n", false, &_init_f_insertRow_3181, &_call_f_insertRow_3181);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QWidget *label, QLayout *field)\n", false, &_init_f_insertRow_3207, &_call_f_insertRow_3207);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, const QString &labelText, QWidget *field)\n", false, &_init_f_insertRow_3891, &_call_f_insertRow_3891);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, const QString &labelText, QLayout *field)\n", false, &_init_f_insertRow_3917, &_call_f_insertRow_3917);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QWidget *widget)\n", false, &_init_f_insertRow_1974, &_call_f_insertRow_1974);
  methods += new qt_gsi::GenericMethod ("insertRow", "@brief Method void QFormLayout::insertRow(int row, QLayout *layout)\n", false, &_init_f_insertRow_2000, &_call_f_insertRow_2000);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Method void QFormLayout::invalidate()\nThis is a reimplementation of QLayout::invalidate", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QFormLayout::itemAt(int row, QFormLayout::ItemRole role)\n", true, &_init_f_itemAt_c3135, &_call_f_itemAt_c3135);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QFormLayout::itemAt(int index)\nThis is a reimplementation of QLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
  methods += new qt_gsi::GenericMethod (":labelAlignment", "@brief Method QFlags<Qt::AlignmentFlag> QFormLayout::labelAlignment()\n", true, &_init_f_labelAlignment_c0, &_call_f_labelAlignment_c0);
  methods += new qt_gsi::GenericMethod ("labelForField", "@brief Method QWidget *QFormLayout::labelForField(QWidget *field)\n", true, &_init_f_labelForField_c1315, &_call_f_labelForField_c1315);
  methods += new qt_gsi::GenericMethod ("labelForField", "@brief Method QWidget *QFormLayout::labelForField(QLayout *field)\n", true, &_init_f_labelForField_c1341, &_call_f_labelForField_c1341);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@brief Method QSize QFormLayout::minimumSize()\nThis is a reimplementation of QLayout::minimumSize", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
  methods += new qt_gsi::GenericMethod ("removeRow", "@brief Method void QFormLayout::removeRow(int row)\n", false, &_init_f_removeRow_767, &_call_f_removeRow_767);
  methods += new qt_gsi::GenericMethod ("removeRow", "@brief Method void QFormLayout::removeRow(QWidget *widget)\n", false, &_init_f_removeRow_1315, &_call_f_removeRow_1315);
  methods += new qt_gsi::GenericMethod ("removeRow", "@brief Method void QFormLayout::removeRow(QLayout *layout)\n", false, &_init_f_removeRow_1341, &_call_f_removeRow_1341);
  methods += new qt_gsi::GenericMethod ("rowCount", "@brief Method int QFormLayout::rowCount()\n", true, &_init_f_rowCount_c0, &_call_f_rowCount_c0);
  methods += new qt_gsi::GenericMethod (":rowWrapPolicy", "@brief Method QFormLayout::RowWrapPolicy QFormLayout::rowWrapPolicy()\n", true, &_init_f_rowWrapPolicy_c0, &_call_f_rowWrapPolicy_c0);
  methods += new qt_gsi::GenericMethod ("setFieldGrowthPolicy|fieldGrowthPolicy=", "@brief Method void QFormLayout::setFieldGrowthPolicy(QFormLayout::FieldGrowthPolicy policy)\n", false, &_init_f_setFieldGrowthPolicy_3418, &_call_f_setFieldGrowthPolicy_3418);
  methods += new qt_gsi::GenericMethod ("setFormAlignment|formAlignment=", "@brief Method void QFormLayout::setFormAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setFormAlignment_2750, &_call_f_setFormAlignment_2750);
  methods += new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QFormLayout::setGeometry(const QRect &rect)\nThis is a reimplementation of QLayout::setGeometry", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
  methods += new qt_gsi::GenericMethod ("setHorizontalSpacing|horizontalSpacing=", "@brief Method void QFormLayout::setHorizontalSpacing(int spacing)\n", false, &_init_f_setHorizontalSpacing_767, &_call_f_setHorizontalSpacing_767);
  methods += new qt_gsi::GenericMethod ("setItem", "@brief Method void QFormLayout::setItem(int row, QFormLayout::ItemRole role, QLayoutItem *item)\n", false, &_init_f_setItem_4767, &_call_f_setItem_4767);
  methods += new qt_gsi::GenericMethod ("setLabelAlignment|labelAlignment=", "@brief Method void QFormLayout::setLabelAlignment(QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_setLabelAlignment_2750, &_call_f_setLabelAlignment_2750);
  methods += new qt_gsi::GenericMethod ("setLayout", "@brief Method void QFormLayout::setLayout(int row, QFormLayout::ItemRole role, QLayout *layout)\n", false, &_init_f_setLayout_4368, &_call_f_setLayout_4368);
  methods += new qt_gsi::GenericMethod ("setRowWrapPolicy|rowWrapPolicy=", "@brief Method void QFormLayout::setRowWrapPolicy(QFormLayout::RowWrapPolicy policy)\n", false, &_init_f_setRowWrapPolicy_3021, &_call_f_setRowWrapPolicy_3021);
  methods += new qt_gsi::GenericMethod ("setSpacing|spacing=", "@brief Method void QFormLayout::setSpacing(int)\n", false, &_init_f_setSpacing_767, &_call_f_setSpacing_767);
  methods += new qt_gsi::GenericMethod ("setVerticalSpacing|verticalSpacing=", "@brief Method void QFormLayout::setVerticalSpacing(int spacing)\n", false, &_init_f_setVerticalSpacing_767, &_call_f_setVerticalSpacing_767);
  methods += new qt_gsi::GenericMethod ("setWidget", "@brief Method void QFormLayout::setWidget(int row, QFormLayout::ItemRole role, QWidget *widget)\n", false, &_init_f_setWidget_4342, &_call_f_setWidget_4342);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QFormLayout::sizeHint()\nThis is a reimplementation of QLayoutItem::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
  methods += new qt_gsi::GenericMethod (":spacing", "@brief Method int QFormLayout::spacing()\n", true, &_init_f_spacing_c0, &_call_f_spacing_c0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@brief Method QLayoutItem *QFormLayout::takeAt(int index)\nThis is a reimplementation of QLayout::takeAt", false, &_init_f_takeAt_767, &_call_f_takeAt_767);
  methods += new qt_gsi::GenericMethod ("takeRow", "@brief Method QFormLayout::TakeRowResult QFormLayout::takeRow(int row)\n", false, &_init_f_takeRow_767, &_call_f_takeRow_767);
  methods += new qt_gsi::GenericMethod ("takeRow", "@brief Method QFormLayout::TakeRowResult QFormLayout::takeRow(QWidget *widget)\n", false, &_init_f_takeRow_1315, &_call_f_takeRow_1315);
  methods += new qt_gsi::GenericMethod ("takeRow", "@brief Method QFormLayout::TakeRowResult QFormLayout::takeRow(QLayout *layout)\n", false, &_init_f_takeRow_1341, &_call_f_takeRow_1341);
  methods += new qt_gsi::GenericMethod (":verticalSpacing", "@brief Method int QFormLayout::verticalSpacing()\n", true, &_init_f_verticalSpacing_c0, &_call_f_verticalSpacing_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QFormLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QFormLayout::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QFormLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QFormLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QLayout> &qtdecl_QLayout ();

qt_gsi::QtNativeClass<QFormLayout> decl_QFormLayout (qtdecl_QLayout (), "QtWidgets", "QFormLayout_Native",
  methods_QFormLayout (),
  "@hide\n@alias QFormLayout");

GSI_QTWIDGETS_PUBLIC gsi::Class<QFormLayout> &qtdecl_QFormLayout () { return decl_QFormLayout; }

}


class QFormLayout_Adaptor : public QFormLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QFormLayout_Adaptor();

  //  [adaptor ctor] QFormLayout::QFormLayout(QWidget *parent)
  QFormLayout_Adaptor() : QFormLayout()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QFormLayout::QFormLayout(QWidget *parent)
  QFormLayout_Adaptor(QWidget *parent) : QFormLayout(parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] void QFormLayout::addChildLayout(QLayout *l)
  void fp_QFormLayout_addChildLayout_1341 (QLayout *l) {
    QFormLayout::addChildLayout(l);
  }

  //  [expose] void QFormLayout::addChildWidget(QWidget *w)
  void fp_QFormLayout_addChildWidget_1315 (QWidget *w) {
    QFormLayout::addChildWidget(w);
  }

  //  [expose] bool QFormLayout::adoptLayout(QLayout *layout)
  bool fp_QFormLayout_adoptLayout_1341 (QLayout *layout) {
    return QFormLayout::adoptLayout(layout);
  }

  //  [expose] QRect QFormLayout::alignmentRect(const QRect &)
  QRect fp_QFormLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QFormLayout::alignmentRect(arg1);
  }

  //  [expose] bool QFormLayout::isSignalConnected(const QMetaMethod &signal)
  bool fp_QFormLayout_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QFormLayout::isSignalConnected(signal);
  }

  //  [expose] int QFormLayout::receivers(const char *signal)
  int fp_QFormLayout_receivers_c1731 (const char *signal) const {
    return QFormLayout::receivers(signal);
  }

  //  [expose] QObject *QFormLayout::sender()
  QObject * fp_QFormLayout_sender_c0 () const {
    return QFormLayout::sender();
  }

  //  [expose] int QFormLayout::senderSignalIndex()
  int fp_QFormLayout_senderSignalIndex_c0 () const {
    return QFormLayout::senderSignalIndex();
  }

  //  [expose] void QFormLayout::widgetEvent(QEvent *)
  void fp_QFormLayout_widgetEvent_1217 (QEvent *arg1) {
    QFormLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QFormLayout::addItem(QLayoutItem *item)
  void cbs_addItem_1740_0(QLayoutItem *item)
  {
    QFormLayout::addItem(item);
  }

  virtual void addItem(QLayoutItem *item)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QFormLayout_Adaptor, QLayoutItem *>(&QFormLayout_Adaptor::cbs_addItem_1740_0, item);
    } else {
      QFormLayout::addItem(item);
    }
  }

  //  [adaptor impl] QFlags<QSizePolicy::ControlType> QFormLayout::controlTypes()
  QFlags<QSizePolicy::ControlType> cbs_controlTypes_c0_0() const
  {
    return QFormLayout::controlTypes();
  }

  virtual QFlags<QSizePolicy::ControlType> controlTypes() const
  {
    if (cb_controlTypes_c0_0.can_issue()) {
      return cb_controlTypes_c0_0.issue<QFormLayout_Adaptor, QFlags<QSizePolicy::ControlType> >(&QFormLayout_Adaptor::cbs_controlTypes_c0_0);
    } else {
      return QFormLayout::controlTypes();
    }
  }

  //  [adaptor impl] int QFormLayout::count()
  int cbs_count_c0_0() const
  {
    return QFormLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QFormLayout_Adaptor, int>(&QFormLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QFormLayout::count();
    }
  }

  //  [emitter impl] void QFormLayout::destroyed(QObject *)
  void emitter_QFormLayout_destroyed_1302(QObject *arg1)
  {
    emit QFormLayout::destroyed(arg1);
  }

  //  [adaptor impl] bool QFormLayout::event(QEvent *event)
  bool cbs_event_1217_0(QEvent *_event)
  {
    return QFormLayout::event(_event);
  }

  virtual bool event(QEvent *_event)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QFormLayout_Adaptor, bool, QEvent *>(&QFormLayout_Adaptor::cbs_event_1217_0, _event);
    } else {
      return QFormLayout::event(_event);
    }
  }

  //  [adaptor impl] bool QFormLayout::eventFilter(QObject *watched, QEvent *event)
  bool cbs_eventFilter_2411_0(QObject *watched, QEvent *event)
  {
    return QFormLayout::eventFilter(watched, event);
  }

  virtual bool eventFilter(QObject *watched, QEvent *event)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QFormLayout_Adaptor, bool, QObject *, QEvent *>(&QFormLayout_Adaptor::cbs_eventFilter_2411_0, watched, event);
    } else {
      return QFormLayout::eventFilter(watched, event);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QFormLayout::expandingDirections()
  QFlags<Qt::Orientation> cbs_expandingDirections_c0_0() const
  {
    return QFormLayout::expandingDirections();
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return cb_expandingDirections_c0_0.issue<QFormLayout_Adaptor, QFlags<Qt::Orientation> >(&QFormLayout_Adaptor::cbs_expandingDirections_c0_0);
    } else {
      return QFormLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QFormLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QFormLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QFormLayout_Adaptor, QRect>(&QFormLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QFormLayout::geometry();
    }
  }

  //  [adaptor impl] bool QFormLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QFormLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QFormLayout_Adaptor, bool>(&QFormLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QFormLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QFormLayout::heightForWidth(int width)
  int cbs_heightForWidth_c767_0(int width) const
  {
    return QFormLayout::heightForWidth(width);
  }

  virtual int heightForWidth(int width) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QFormLayout_Adaptor, int, int>(&QFormLayout_Adaptor::cbs_heightForWidth_c767_0, width);
    } else {
      return QFormLayout::heightForWidth(width);
    }
  }

  //  [adaptor impl] int QFormLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QFormLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QFormLayout_Adaptor, int, QWidget *>(&QFormLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QFormLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QFormLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QFormLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QFormLayout_Adaptor>(&QFormLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QFormLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QFormLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QFormLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QFormLayout_Adaptor, bool>(&QFormLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QFormLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QFormLayout::itemAt(int index)
  QLayoutItem * cbs_itemAt_c767_0(int index) const
  {
    return QFormLayout::itemAt(index);
  }

  virtual QLayoutItem * itemAt(int index) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QFormLayout_Adaptor, QLayoutItem *, int>(&QFormLayout_Adaptor::cbs_itemAt_c767_0, index);
    } else {
      return QFormLayout::itemAt(index);
    }
  }

  //  [adaptor impl] QLayout *QFormLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QFormLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QFormLayout_Adaptor, QLayout *>(&QFormLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QFormLayout::layout();
    }
  }

  //  [adaptor impl] QSize QFormLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QFormLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QFormLayout_Adaptor, QSize>(&QFormLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QFormLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QFormLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QFormLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QFormLayout_Adaptor, int, int>(&QFormLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QFormLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QFormLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QFormLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QFormLayout_Adaptor, QSize>(&QFormLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QFormLayout::minimumSize();
    }
  }

  //  [emitter impl] void QFormLayout::objectNameChanged(const QString &objectName)
  void emitter_QFormLayout_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QFormLayout::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QFormLayout::setGeometry(const QRect &rect)
  void cbs_setGeometry_1792_0(const QRect &rect)
  {
    QFormLayout::setGeometry(rect);
  }

  virtual void setGeometry(const QRect &rect)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QFormLayout_Adaptor, const QRect &>(&QFormLayout_Adaptor::cbs_setGeometry_1792_0, rect);
    } else {
      QFormLayout::setGeometry(rect);
    }
  }

  //  [adaptor impl] QSize QFormLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QFormLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QFormLayout_Adaptor, QSize>(&QFormLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QFormLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QFormLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QFormLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QFormLayout_Adaptor, QSpacerItem *>(&QFormLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QFormLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QFormLayout::takeAt(int index)
  QLayoutItem * cbs_takeAt_767_0(int index)
  {
    return QFormLayout::takeAt(index);
  }

  virtual QLayoutItem * takeAt(int index)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QFormLayout_Adaptor, QLayoutItem *, int>(&QFormLayout_Adaptor::cbs_takeAt_767_0, index);
    } else {
      return QFormLayout::takeAt(index);
    }
  }

  //  [adaptor impl] QWidget *QFormLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QFormLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QFormLayout_Adaptor, QWidget *>(&QFormLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QFormLayout::widget();
    }
  }

  //  [adaptor impl] void QFormLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QFormLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QFormLayout_Adaptor, QChildEvent *>(&QFormLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QFormLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QFormLayout::customEvent(QEvent *event)
  void cbs_customEvent_1217_0(QEvent *event)
  {
    QFormLayout::customEvent(event);
  }

  virtual void customEvent(QEvent *event)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QFormLayout_Adaptor, QEvent *>(&QFormLayout_Adaptor::cbs_customEvent_1217_0, event);
    } else {
      QFormLayout::customEvent(event);
    }
  }

  //  [adaptor impl] void QFormLayout::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QFormLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QFormLayout_Adaptor, const QMetaMethod &>(&QFormLayout_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QFormLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QFormLayout::timerEvent(QTimerEvent *event)
  void cbs_timerEvent_1730_0(QTimerEvent *event)
  {
    QFormLayout::timerEvent(event);
  }

  virtual void timerEvent(QTimerEvent *event)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QFormLayout_Adaptor, QTimerEvent *>(&QFormLayout_Adaptor::cbs_timerEvent_1730_0, event);
    } else {
      QFormLayout::timerEvent(event);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_controlTypes_c0_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QFormLayout_Adaptor::~QFormLayout_Adaptor() { }

//  Constructor QFormLayout::QFormLayout(QWidget *parent) (adaptor class)

static void _init_ctor_QFormLayout_Adaptor_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("parent", true, "nullptr");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return_new<QFormLayout_Adaptor> ();
}

static void _call_ctor_QFormLayout_Adaptor_1315 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args ? gsi::arg_reader<QWidget * >() (args, heap) : gsi::arg_maker<QWidget * >() (nullptr, heap);
  ret.write<QFormLayout_Adaptor *> (new QFormLayout_Adaptor (arg1));
}


// exposed void QFormLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  qt_gsi::qt_keep (arg1);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->fp_QFormLayout_addChildLayout_1341 (arg1);
}


// exposed void QFormLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = gsi::arg_reader<QWidget * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->fp_QFormLayout_addChildWidget_1315 (arg1);
}


// void QFormLayout::addItem(QLayoutItem *item)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("item");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayoutItem *arg1 = args.read<QLayoutItem * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}


// exposed bool QFormLayout::adoptLayout(QLayout *layout)

static void _init_fp_adoptLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_adoptLayout_1341 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QLayout *arg1 = gsi::arg_reader<QLayout * >() (args, heap);
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_adoptLayout_1341 (arg1));
}


// exposed QRect QFormLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = gsi::arg_reader<const QRect & >() (args, heap);
  ret.write<QRect > ((QRect)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_alignmentRect_c1792 (arg1));
}


// void QFormLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// QFlags<QSizePolicy::ControlType> QFormLayout::controlTypes()

static void _init_cbs_controlTypes_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<QSizePolicy::ControlType> > ();
}

static void _call_cbs_controlTypes_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<QSizePolicy::ControlType> > ((QFlags<QSizePolicy::ControlType>)((QFormLayout_Adaptor *)cls)->cbs_controlTypes_c0_0 ());
}

static void _set_callback_cbs_controlTypes_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_controlTypes_c0_0 = cb;
}


// int QFormLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}


// void QFormLayout::customEvent(QEvent *event)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QFormLayout::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "nullptr");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (nullptr, heap);
  ((QFormLayout_Adaptor *)cls)->emitter_QFormLayout_destroyed_1302 (arg1);
}


// void QFormLayout::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QFormLayout::event(QEvent *event)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QFormLayout::eventFilter(QObject *watched, QEvent *event)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("watched");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("event");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QFlags<Qt::Orientation> QFormLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QFlags<Qt::Orientation> > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QFlags<Qt::Orientation> > ((QFlags<Qt::Orientation>)((QFormLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}


// QRect QFormLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QRect > ((QRect)((QFormLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}


// bool QFormLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}


// int QFormLayout::heightForWidth(int width)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("width");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}


// int QFormLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QWidget *arg1 = args.read<QWidget * > (heap);
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}


// void QFormLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}


// bool QFormLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}


// exposed bool QFormLayout::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_isSignalConnected_c2394 (arg1));
}


// QLayoutItem *QFormLayout::itemAt(int index)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}


// QLayout *QFormLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QLayout * > ((QLayout *)((QFormLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}


// QSize QFormLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFormLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}


// int QFormLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}


// QSize QFormLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFormLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}


// emitter void QFormLayout::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QFormLayout_Adaptor *)cls)->emitter_QFormLayout_objectNameChanged_4567 (arg1);
}


// exposed int QFormLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_receivers_c1731 (arg1));
}


// exposed QObject *QFormLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_sender_c0 ());
}


// exposed int QFormLayout::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QFormLayout_Adaptor *)cls)->fp_QFormLayout_senderSignalIndex_c0 ());
}


// void QFormLayout::setGeometry(const QRect &rect)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("rect");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QRect &arg1 = args.read<const QRect & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}


// QSize QFormLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSize > ((QSize)((QFormLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}


// QSpacerItem *QFormLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QSpacerItem * > ((QSpacerItem *)((QFormLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}


// QLayoutItem *QFormLayout::takeAt(int index)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  ret.write<QLayoutItem * > ((QLayoutItem *)((QFormLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}


// void QFormLayout::timerEvent(QTimerEvent *event)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("event");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// QWidget *QFormLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QWidget * > ((QWidget *)((QFormLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QFormLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}


// exposed void QFormLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = gsi::arg_reader<QEvent * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QFormLayout_Adaptor *)cls)->fp_QFormLayout_widgetEvent_1217 (arg1);
}


namespace gsi
{

gsi::Class<QFormLayout> &qtdecl_QFormLayout ();

static gsi::Methods methods_QFormLayout_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QFormLayout::QFormLayout(QWidget *parent)\nThis method creates an object of class QFormLayout.", &_init_ctor_QFormLayout_Adaptor_1315, &_call_ctor_QFormLayout_Adaptor_1315);
  methods += new qt_gsi::GenericMethod ("*addChildLayout", "@brief Method void QFormLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
  methods += new qt_gsi::GenericMethod ("*addChildWidget", "@brief Method void QFormLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
  methods += new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QFormLayout::addItem(QLayoutItem *item)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
  methods += new qt_gsi::GenericMethod ("*adoptLayout", "@brief Method bool QFormLayout::adoptLayout(QLayout *layout)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_adoptLayout_1341, &_call_fp_adoptLayout_1341);
  methods += new qt_gsi::GenericMethod ("*alignmentRect", "@brief Method QRect QFormLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QFormLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@brief Virtual method QFlags<QSizePolicy::ControlType> QFormLayout::controlTypes()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("controlTypes", "@hide", true, &_init_cbs_controlTypes_c0_0, &_call_cbs_controlTypes_c0_0, &_set_callback_cbs_controlTypes_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@brief Virtual method int QFormLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QFormLayout::customEvent(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QFormLayout::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QFormLayout::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QFormLayout::event(QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QFormLayout::eventFilter(QObject *watched, QEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QFormLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QFormLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QFormLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QFormLayout::heightForWidth(int width)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QFormLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
  methods += new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QFormLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QFormLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QFormLayout::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QFormLayout::itemAt(int index)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
  methods += new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QFormLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QFormLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QFormLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QFormLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QFormLayout::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QFormLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QFormLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QFormLayout::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QFormLayout::setGeometry(const QRect &rect)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QFormLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QFormLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QFormLayout::takeAt(int index)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QFormLayout::timerEvent(QTimerEvent *event)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QFormLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
  methods += new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
  methods += new qt_gsi::GenericMethod ("*widgetEvent", "@brief Method void QFormLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
  return methods;
}

gsi::Class<QFormLayout_Adaptor> decl_QFormLayout_Adaptor (qtdecl_QFormLayout (), "QtWidgets", "QFormLayout",
  methods_QFormLayout_Adaptor (),
  "@qt\n@brief Binding of QFormLayout");

}


//  Implementation of the enum wrapper class for QFormLayout::FieldGrowthPolicy
namespace qt_gsi
{

static gsi::Enum<QFormLayout::FieldGrowthPolicy> decl_QFormLayout_FieldGrowthPolicy_Enum ("QtWidgets", "QFormLayout_FieldGrowthPolicy",
    gsi::enum_const ("FieldsStayAtSizeHint", QFormLayout::FieldsStayAtSizeHint, "@brief Enum constant QFormLayout::FieldsStayAtSizeHint") +
    gsi::enum_const ("ExpandingFieldsGrow", QFormLayout::ExpandingFieldsGrow, "@brief Enum constant QFormLayout::ExpandingFieldsGrow") +
    gsi::enum_const ("AllNonFixedFieldsGrow", QFormLayout::AllNonFixedFieldsGrow, "@brief Enum constant QFormLayout::AllNonFixedFieldsGrow"),
  "@qt\n@brief This class represents the QFormLayout::FieldGrowthPolicy enum");

static gsi::QFlagsClass<QFormLayout::FieldGrowthPolicy > decl_QFormLayout_FieldGrowthPolicy_Enums ("QtWidgets", "QFormLayout_QFlags_FieldGrowthPolicy",
  "@qt\n@brief This class represents the QFlags<QFormLayout::FieldGrowthPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFormLayout> inject_QFormLayout_FieldGrowthPolicy_Enum_in_parent (decl_QFormLayout_FieldGrowthPolicy_Enum.defs ());
static gsi::ClassExt<QFormLayout> decl_QFormLayout_FieldGrowthPolicy_Enum_as_child (decl_QFormLayout_FieldGrowthPolicy_Enum, "FieldGrowthPolicy");
static gsi::ClassExt<QFormLayout> decl_QFormLayout_FieldGrowthPolicy_Enums_as_child (decl_QFormLayout_FieldGrowthPolicy_Enums, "QFlags_FieldGrowthPolicy");

}


//  Implementation of the enum wrapper class for QFormLayout::ItemRole
namespace qt_gsi
{

static gsi::Enum<QFormLayout::ItemRole> decl_QFormLayout_ItemRole_Enum ("QtWidgets", "QFormLayout_ItemRole",
    gsi::enum_const ("LabelRole", QFormLayout::LabelRole, "@brief Enum constant QFormLayout::LabelRole") +
    gsi::enum_const ("FieldRole", QFormLayout::FieldRole, "@brief Enum constant QFormLayout::FieldRole") +
    gsi::enum_const ("SpanningRole", QFormLayout::SpanningRole, "@brief Enum constant QFormLayout::SpanningRole"),
  "@qt\n@brief This class represents the QFormLayout::ItemRole enum");

static gsi::QFlagsClass<QFormLayout::ItemRole > decl_QFormLayout_ItemRole_Enums ("QtWidgets", "QFormLayout_QFlags_ItemRole",
  "@qt\n@brief This class represents the QFlags<QFormLayout::ItemRole> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFormLayout> inject_QFormLayout_ItemRole_Enum_in_parent (decl_QFormLayout_ItemRole_Enum.defs ());
static gsi::ClassExt<QFormLayout> decl_QFormLayout_ItemRole_Enum_as_child (decl_QFormLayout_ItemRole_Enum, "ItemRole");
static gsi::ClassExt<QFormLayout> decl_QFormLayout_ItemRole_Enums_as_child (decl_QFormLayout_ItemRole_Enums, "QFlags_ItemRole");

}


//  Implementation of the enum wrapper class for QFormLayout::RowWrapPolicy
namespace qt_gsi
{

static gsi::Enum<QFormLayout::RowWrapPolicy> decl_QFormLayout_RowWrapPolicy_Enum ("QtWidgets", "QFormLayout_RowWrapPolicy",
    gsi::enum_const ("DontWrapRows", QFormLayout::DontWrapRows, "@brief Enum constant QFormLayout::DontWrapRows") +
    gsi::enum_const ("WrapLongRows", QFormLayout::WrapLongRows, "@brief Enum constant QFormLayout::WrapLongRows") +
    gsi::enum_const ("WrapAllRows", QFormLayout::WrapAllRows, "@brief Enum constant QFormLayout::WrapAllRows"),
  "@qt\n@brief This class represents the QFormLayout::RowWrapPolicy enum");

static gsi::QFlagsClass<QFormLayout::RowWrapPolicy > decl_QFormLayout_RowWrapPolicy_Enums ("QtWidgets", "QFormLayout_QFlags_RowWrapPolicy",
  "@qt\n@brief This class represents the QFlags<QFormLayout::RowWrapPolicy> flag set");

//  Inject the declarations into the parent
static gsi::ClassExt<QFormLayout> inject_QFormLayout_RowWrapPolicy_Enum_in_parent (decl_QFormLayout_RowWrapPolicy_Enum.defs ());
static gsi::ClassExt<QFormLayout> decl_QFormLayout_RowWrapPolicy_Enum_as_child (decl_QFormLayout_RowWrapPolicy_Enum, "RowWrapPolicy");
static gsi::ClassExt<QFormLayout> decl_QFormLayout_RowWrapPolicy_Enums_as_child (decl_QFormLayout_RowWrapPolicy_Enums, "QFlags_RowWrapPolicy");

}

