# Workflow

This project uses gitflow, here some documentation about [how gitflow works](https://datasift.github.io/gitflow/IntroducingGitFlow.html)

# Issues

Bugs, RFE or others should be documented in the [issues](https://github.com/rackerlabs/kthresher/issues/).

## Guidelines
1. Before opening an issue, search [open](https://github.com/rackerlabs/kthresher/issues?q=is%3Aopen+is%3Aissue) and [closed](https://github.com/rackerlabs/kthresher/issues?q=is%3Aissue+is%3Aclosed) issues to ensure the issue has not ben reported previously.
1. Ensure the issue can be reproduced with the latest [`development`](https://github.com/rackerlabs/kthresher/tree/development) version.
1. The issue should contain detailed instructions and when possible logs, as well as the expected result.
1. Include details of the environment where it's running, e.g. Debian Jessie, CentOS 7.3, etc.
1. For RFE explain *Why would this feature be useful?*

# Pull Requests

Code contributions are greatly appreciated, please make sure you follow the guidelines below.

## Pull requests should be
1. Made against the `development` branch.
1. Made from a git feature/fix branch.
1. Associated to a documented issue.

## Pull requests will not be accepted that
1. Are not made against the `development` branch
1. Are made by editing files via the GitHub website
1. Does not have a documented [issue](https://github.com/rackerlabs/kthresher/issues/) for it.

# Coding Guidelines

- pep8/pycodestyle
- pyflakes

# Testing

- None at the moment :(, would be nice to have some.
