/*
 * Copyright (C) 2014 Canonical Ltd
 *
 * This file is part of Lomiri Calendar App
 *
 * Lomiri Calendar App is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * Lomiri Calendar App is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import QtQuick 2.4
import Lomiri.Components 1.3
import Lomiri.SyncMonitor 0.1
import Qt.labs.settings 1.0

Item {
    id: actionPool

    property alias showCalendarAction: _showCalendarAction
    property alias syncCalendarAction: _syncCalendarAction
    property alias settingsAction: _settingsAction
    property Settings settings
    readonly property bool syncInProgress: (syncMonitor.state !== "") && (syncMonitor.state === "syncing")

    Action {
        id: _syncCalendarAction
        objectName: "syncbutton"
        // iconName: !actionPool.syncInProgress ? "sync" : "sync-cancel" //restore this once syn-cancel icon is upstream
        iconSource: !actionPool.syncInProgress ? "../assets/sync.svg" : "../assets/sync-cancel.svg"
        // TRANSLATORS: Please translate this string  to 15 characters only.
        // Currently ,there is no way we can increase width of action menu currently.
        text: !actionPool.syncInProgress ? i18n.tr("Sync") : i18n.tr("Syncing")
        onTriggered: !actionPool.syncInProgress ? syncMonitor.sync(["calendar"]) : syncMonitor.cancel(["calendar"])
        enabled: syncMonitor.enabledServices ? syncMonitor.serviceIsEnabled("calendar") : false
        visible: syncMonitor.enabledServices ? true : false
    }

    SyncMonitor {
        id: syncMonitor
    }

    Action{
        id: _showCalendarAction
        objectName: "calendarsbutton"
        name: "calendarsbutton"
        iconName: "calendar"
        text: i18n.tr("Calendars")
        onTriggered: {
            pageStack.push(Qt.resolvedUrl("CalendarChoicePopup.qml"),{"model":eventModel});
            pageStack.currentPage.collectionUpdated.connect(eventModel.delayedApplyFilter);
        }
    }

    Action{
        id: _settingsAction
        objectName: "settingsbutton"
        name: "calendarsbutton"
        iconName: "settings"
        text: i18n.tr("Settings")
        onTriggered: pageStack.push(Qt.resolvedUrl("SettingsPage.qml"), {"eventModel": eventModel,
                                                                         "settings": actionPool.settings});
    }
}
