/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.reflect;

import alt.jiapi.file.Attribute;
import alt.jiapi.file.Field;
import alt.jiapi.reflect.JiapiClass;
import alt.jiapi.reflect.Loader;
import alt.jiapi.reflect.TypeHelper;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.List;

public class JiapiField {
    private JiapiClass declaringClass;
    private Field field;

    JiapiField(Field f) {
        this.field = f;
    }

    public String getName() {
        return this.field.getName();
    }

    public JiapiClass getType() throws ClassNotFoundException {
        Loader loader = this.getDeclaringClass().getLoader();
        JiapiClass clazz = null;
        try {
            clazz = loader.loadClass(this.getTypeName());
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException(this.getTypeName());
        }
        return clazz;
    }

    public String getTypeName() {
        String descriptor = this.getDescriptor();
        String type = TypeHelper.descriptorToType(descriptor);
        return type;
    }

    String getDescriptor() {
        return this.field.getDescriptor();
    }

    public int getModifiers() {
        return this.field.getAccessFlags();
    }

    void setModifiers(int modifiers) {
        throw new RuntimeException("Operation not supported");
    }

    Field getField() {
        return this.field;
    }

    public JiapiClass getDeclaringClass() {
        return this.declaringClass;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(Modifier.toString(this.getModifiers()));
        sb.append(' ');
        sb.append(this.getTypeName());
        sb.append(' ');
        sb.append(this.getName());
        return sb.toString();
    }

    void setDeclaringClass(JiapiClass declaringClass) {
        this.declaringClass = declaringClass;
    }

    private List getAttributes() {
        return this.field.getAttributes();
    }

    private Attribute getAttribute(String name) {
        List l = this.getAttributes();
        for (Attribute a : l) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }
}

