#if !defined (__ADAPTER_HPP)
#define __ADAPTER_HPP

/*
  CoreLinux++ 
  Copyright (C) 1999,2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif
  

namespace corelinux
{

   DECLARE_CLASS( Adapter );

   /**
   An Adapter converts the interface of a class into another
   interface that clients expect. This allows classes work together that
   couldn't otherwise because of the incompatible interfaces. Sometimes
   a toolkit class that's designed for reuse isn't reusable only because
   its interface doesn't match the domain specific interface an
   application requires.
   */

   class Adapter
   {
   public:

                           /// Default Constructor

                           Adapter( void );

                           /** Copy Constructor
                           @param Adapter const reference
                           */

                           Adapter( AdapterCref );

                           /// Virtual Destructor  

      virtual              ~Adapter( void );

      //
      // Operator overloads
      //
               /**
               Assignment operator overload
               @param  Adapter const reference
               @return Adapter reference to self
               */
            
               AdapterRef  operator=( AdapterCref );

               /**
               Equality operator overload
               @param Adapter const reference
               @return true if equal, false otherwise
               */

               bool        operator==( AdapterCref ) const;

               /**
               Non-equality operator overload
               @param Adapter const reference
               @return false if equal, true otherwise
               */

               bool        operator!=( AdapterCref ) const;

   };

}
          
#endif   // if !defined(__ADAPTER_HPP)

/*
   Common rcs information do not modify
   $Author: prudhomm $
   $Revision: 1.1 $
   $Date: 2000/04/23 20:43:13 $
   $Locker:  $
*/


