/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <corelinux/Common.hpp>
#endif

#if   !defined(__RESTORECASECOMMAND_HPP)
#include <RestoreCaseCommand.hpp>
#endif

using namespace corelinux;

// Default

RestoreCaseCommand::RestoreCaseCommand( void )
   :
   Command(),
   theOriginalValue( NULLPTR ),
   theRestoredValue( NULLPTR )
{
   ;  // do nothing
}

//  Copy not allowed

RestoreCaseCommand::RestoreCaseCommand( RestoreCaseCommandCref )
   throw ( Assertion )
   :
   Command(),
   theOriginalValue( NULLPTR ),
   theRestoredValue( NULLPTR )
{
   NEVER_GET_HERE;
}

// Destructor

RestoreCaseCommand::~RestoreCaseCommand( void )
{
   theOriginalValue = NULLPTR;
   theRestoredValue = NULLPTR;
}

// Assignment

RestoreCaseCommandRef RestoreCaseCommand::operator=( RestoreCaseCommandCref )
   throw ( Assertion )
{
   NEVER_GET_HERE;
   return ( *this );
}

// Operator equals

bool RestoreCaseCommand::operator==
   ( 
      RestoreCaseCommandCref aRestoreCommand 
   ) const
{
   return ( this == &aRestoreCommand );
}

// Set the execution values

void RestoreCaseCommand::setValues( std::string **orig, std::string **restored )
   throw ( Assertion )
{
   REQUIRE( orig != NULLPTR && *orig != NULLPTR );
   REQUIRE( restored != NULLPTR && *restored != NULLPTR );
   theOriginalValue = orig;
   theRestoredValue = restored;
}

// Execute

void  RestoreCaseCommand::execute( void )
{
   if( theOriginalValue != NULLPTR &&
       *theOriginalValue != NULLPTR )
   {
      if( theRestoredValue != NULLPTR &&
          theRestoredValue != NULLPTR )
      {
         **theRestoredValue = **theOriginalValue;
      }
      else
      {
         ;  // do nothing
      }
   }
   else
   {
      ;  // do nothing
   }
}
/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/04 05:41:59 $
   $Locker:  $
*/

