/**
 *
 */
package org.jboss.cache.eviction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.EvictionPolicyConfig;

/**
 * Eviction policy that does nothing and always tells the eviction
 * interceptor an event can be ignored, saving the overhead of
 * constructing and processing event objects. Basically useful
 * as a default policy for a cache or subtree that is
 * shared between multiple usages, some of which don't
 * want eviction.
 *
 * @author Brian Stansberry
 */
public class NullEvictionPolicy implements EvictionPolicy
{
   private static final Log log = LogFactory.getLog(NullEvictionPolicy.class);

   private CacheSPI cache;

   /**
    * Returns <code>true</code>
    */
   public boolean canIgnoreEvent(Fqn fqn, NodeEventType eventType)
   {
      return true;
   }

   /**
    * No-op
    */
   public void evict(Fqn fqn) throws Exception
   {
      log.debug("evict should not be called on NullEvictionPolicy");
   }

   /**
    * Returns {@link NullEvictionAlgorithm#INSTANCE}.
    */
   public EvictionAlgorithm getEvictionAlgorithm()
   {
      return NullEvictionAlgorithm.INSTANCE;
   }

   /**
    * Returns {@link NullEvictionPolicyConfig}.
    */
   public Class<? extends EvictionPolicyConfig> getEvictionConfigurationClass()
   {
      return NullEvictionPolicyConfig.class;
   }

   public CacheSPI getCache()
   {
      return cache;
   }

   public void setCache(CacheSPI cache)
   {
      this.cache = cache;
   }

}
