package org.jboss.cache.loader;

import org.jboss.cache.AbstractMultipleCachesTest;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.UnitTestCacheFactory;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.factories.UnitTestConfigurationFactory;
import org.testng.annotations.Test;

/**
 * Test read only clustered cache loader.
 *
 * @author Galder Zamarreño
 * @since 3.2.6
 */
@Test(groups = {"functional"}, testName = "loader.ReadOnlyClusteredCacheLoaderTest")
public class ReadOnlyClusteredCacheLoaderTest extends AbstractMultipleCachesTest {

   private CacheSPI<String, String> cache1, cache2;
   
   @Override
   protected void createCaches() throws Throwable {
      Configuration c1 = new Configuration();
      Configuration c2 = new Configuration();
      c1.setCacheMode(Configuration.CacheMode.REPL_SYNC);
      c2.setCacheMode(Configuration.CacheMode.REPL_SYNC);

      c1.setCacheLoaderConfig(UnitTestConfigurationFactory.buildSingleCacheLoaderConfig(false, "", "org.jboss.cache.loader.ClusteredCacheLoader",
            "timeout=5000", false, false, false, false, true));
      c2.setCacheLoaderConfig(UnitTestConfigurationFactory.buildSingleCacheLoaderConfig(false, "", "org.jboss.cache.loader.ClusteredCacheLoader",
            "timeout=5000", false, false, false, false, true));

      cache1 = (CacheSPI<String, String>) new UnitTestCacheFactory<String, String>().createCache(c1, false, getClass());
      cache2 = (CacheSPI<String, String>) new UnitTestCacheFactory<String, String>().createCache(c2, false, getClass());
      cache1.start();
      cache2.start();
      registerCaches(cache1, cache2);      
   }


   public void testReadOnlyAccess() throws Exception {
      Node<String, String> rootNode = cache1.getRoot();
      Fqn<String> fqn = Fqn.fromElements("blap");
      Node<String, String> child = rootNode.getChild(fqn);
   }

}
