<?xml version="1.0" encoding="UTF-8" ?>

<!-- 
(c) Copyright 2006 Hewlett-Packard Development Company, LP
 [See middle of file]
-->
 

<!--
    Created on : 06 January 2006, 08:44
    Author     : jjc
    Description:
        Turns violations.xml into ViolationCodes.java.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
    <xsl:output method="text"/>
    <xsl:template match="/">
    
    <!--    Extended validation -->
    <xsl:if test="//*[@fragment][@section]">
      <xsl:message terminate="yes">Must not have both fragment and section specified</xsl:message>
    </xsl:if>
    
    <xsl:for-each select="//text[@component]">
      <xsl:variable name="t" select="."/>
      <xsl:for-each select="preceding-sibling::text|following-sibling::text">
          <xsl:if test="not(@component)">
              <xsl:message terminate="yes">
         Multiple texts must either all have components or none
              </xsl:message>
          </xsl:if>
          <xsl:if test="@component = $t/@component">
              <xsl:message terminate="yes">
         Multiple texts must refer to different components
              </xsl:message>
          </xsl:if>
      </xsl:for-each>
    </xsl:for-each>
    
    <!--    End Extended validation -->
    
/*
 * (c) Copyright 2006 Hewlett-Packard Development Company, LP
 * [See end of file]
 */
 /*
 AUTOGENERATED FILE: DO NOT EDIT
 */

package com.hp.hpl.jena.iri;

import com.hp.hpl.jena.iri.impl.ViolationCodeInfo;

import com.hp.hpl.jena.iri.impl.ViolationCodeInfo.InSpec;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo.FromSpec_iri;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo.FromSpec_other;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo.FromSpec_scheme;
import com.hp.hpl.jena.iri.impl.ViolationCodeInfo.FromAlso;
import com.hp.hpl.jena.iri.impl.Specification;
import com.hp.hpl.jena.iri.impl.SchemeSpecification;
import com.hp.hpl.jena.iri.impl.Force;
 
/**
 * Detailed description of problems detected.
 * This interface lists the codes returned by 
 * {@link Violation#getViolationCode()}.
 * Note: not all are errors, some merely reflect internal workings.
 
 &lt;p>The violations are evaluated against the following standards:
 &lt;/p>
 &lt;dl>
  <xsl:apply-templates select="descendant::specification[@type='iri']" mode="javadoc"/> 
 &lt;/dl>
 
 &lt;p>Scheme specific checks are enabled. The syntax of the following schemes is fully supported:
 &lt;/p>
 &lt;dl>
  <xsl:apply-templates select="descendant::scheme[complete]" mode="javadoc"/> 
 &lt;/dl>
 
 
 &lt;p>The syntax of the following schemes is partially supported:
 &lt;/p>
 &lt;dl>
  <xsl:apply-templates select="descendant::scheme[not(complete)][*[not(self::name)]]" mode="javadoc"/> 
 &lt;/dl>
 
 
 &lt;p>The names of the following registered schemes are known, but they are otherwise unsupported:
 &lt;/p>
 &lt;dl>
  <xsl:apply-templates select="descendant::scheme[not(complete)][not(*[not(self::name)])]" mode="javadoc"/> 
 &lt;/dl>
 
 &lt;p>Other relevant standards include:
 &lt;/p>
 &lt;dl>
  <xsl:apply-templates select="descendant::specification[@type='other']" mode="javadoc"/> 
 &lt;/dl>
 
 
 
 * @author Jeremy J. Carroll
 *
 */
public interface ViolationCodes {
   
/**
This class is not part of the API.
*/
   class Initialize implements IRIComponents, Force {
   static {
   
   Specification spec;
   
   <xsl:apply-templates select="descendant::specification" mode="static"/>
   
   
   <xsl:apply-templates select="descendant::scheme" mode="static"/>
   
   <xsl:apply-templates select="descendant::violation" mode="static"/>
     }
   }
   
   <xsl:apply-templates select="descendant::violation" mode="top"/>


<!-- Note the copyright statement immediately below refers both to the
    file produced and to this file.  -->
}


/*
 *  (c) Copyright 2006 Hewlett-Packard Development Company, LP
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
    </xsl:template>

    <xsl:template match="violation" mode="top">
/**<xsl:apply-templates select="." mode="javadoc"/>
*/
        int <xsl:value-of select= "name"/> = <xsl:value-of select="count(preceding::violation)"/>;
        
    </xsl:template>
    
    
    
    <xsl:template match="violation[internal]" mode="javadoc" >
    Internal code. This is not an error or warning condition, 
    but is used to trigger more expensive processing.
    </xsl:template>
    
    <xsl:template match="violation[description]" mode="javadoc" >
       <xsl:value-of select="description"/>
       
       <xsl:apply-templates select="comment"  mode="javadoc"/>
       
       <xsl:apply-templates select="spec" mode="javadoc"/>
       
       <xsl:if test="count((spec|also)[id(@ref)/@type='iri' or id(@ref)/@type='scheme']) = 1">
          &lt;p>This violates the &lt;a href=
          "#ref-<xsl:value-of select="(spec[id(@ref)/@type='iri' or id(@ref)/@type='scheme']|also)/@ref"/>">[<xsl:value-of select="(spec[id(@ref)/@type='iri' or id(@ref)/@type='scheme']|also)/@ref"/>]&lt;/a>
          specification.&lt;/p>
       </xsl:if>
       <xsl:if test="count((spec|also)[id(@ref)/@type='iri' or id(@ref)/@type='scheme']) > 1">
          &lt;p>This violates the following specifications:
          <xsl:apply-templates 
                 select="((spec|also)[id(@ref)/@type='iri' or id(@ref)/@type='scheme'])" 
                 mode="javadoc-spec-list"/>.
          &lt;/p>
       </xsl:if>
       <xsl:if test="not((spec|also)[id(@ref)/@type='iri' or id(@ref)/@type='scheme'])">
         &lt;p>This does not violate any of the supported IRI, URI or scheme specifications.&lt;/p>
       </xsl:if>
       
       <xsl:apply-templates select="should|minting|security|dns|must" mode="javadoc"/>
       <xsl:if test="not(must|should|minting|security)">
         &lt;p>This violation has &lt;a href="http://www.apps.ietf.org/rfc/rfc2119.html#sec-1">MUST&lt;/a> force.&lt;/p>
       </xsl:if>
       
       <xsl:if test="bad">
        &lt;p>The following are examples of IRIs that have this violation:&lt;/p>
        &lt;ul>
       <xsl:apply-templates select="bad" mode="javadoc"/>
        &lt;/ul>
       </xsl:if>
       
       <xsl:if test="good">
        &lt;p>The following are examples of IRIs that do not have this violation:&lt;/p>
        &lt;ul>
       <xsl:apply-templates select="good" mode="javadoc"/>
        &lt;/ul>
       </xsl:if>
       
       <xsl:if test="unimplemented">
         &lt;p>Unimplemented.&lt;/p>
       </xsl:if>
       
       <xsl:apply-templates select="see" mode="javadoc"/>
      
    </xsl:template>
    
    <xsl:template match="violation" mode="javadoc">
       // TODO complete entry for <xsl:value-of select= "name"/>
    </xsl:template>
    
    <xsl:template match="spec" mode="javadoc">
     &lt;p>This is specified in &lt;a href="#ref-<xsl:value-of select="@ref"/>">
     [<xsl:value-of select="@ref"/>]&lt;/a>.&lt;/p>
     &lt;dl>
     <xsl:apply-templates select="text"  mode="javadoc"/>
     &lt;/dl>
     
    </xsl:template>
    
    <xsl:template match="defn[@ref]" mode="javadocDefn">
       See &lt;a href="#ref-<xsl:value-of select="@ref"/>">
     [<xsl:value-of select="@ref"/>]&lt;/a>, specifically,
      <xsl:apply-templates select="." mode="javadoc-link"/>
    </xsl:template>
     <xsl:template match="defn[not(@ref)]" mode="javadocDefn">
       See
      <xsl:apply-templates select="." mode="javadoc-link"/>
    </xsl:template>
    
    <xsl:template match="defn" mode="javadoc">
      &lt;dt><xsl:apply-templates select="." mode="javadocDefn"/>
      &lt;/dt>
      &lt;dd><xsl:apply-templates select="node()" mode="javadoc"/>
      &lt;/dd>
    </xsl:template>
    
    <xsl:template match="text" mode="javadoc">
     &lt;dt>
     <xsl:if test="@component">
       For the <xsl:value-of select="@component"/> component:
     </xsl:if>
       see
     <xsl:apply-templates select="." mode="javadoc-link"/>
     &lt;/dt>
     &lt;dd>
     <xsl:apply-templates select="node()" mode="javadoc"/>
     &lt;/dd>
    </xsl:template>
    
    <xsl:template match="comment" mode="javadoc">
     &lt;p>
     <xsl:apply-templates select="node()" mode="javadoc"/>
     &lt;/p>
    </xsl:template>
    
    
    <xsl:template match="text()" mode="javadoc">
       <xsl:call-template name="escape-text">
         <xsl:with-param name="t" select="."/>
       </xsl:call-template>
     </xsl:template>
     
     <xsl:variable name="escape-text-rules">&lt;;&amp;lt;:</xsl:variable>
    
     <xsl:template name="escape-text">
      <xsl:param name="t"/>
                <xsl:call-template name="translate">
                     <xsl:with-param name="string" select="$t"/>
                     <xsl:with-param name="rules" select="$escape-text-rules"/>
                </xsl:call-template>
     </xsl:template>
     
    <xsl:template match="pre" mode="javadoc">
     &lt;pre><xsl:apply-templates select="node()" mode="javadoc"/>&lt;/pre>
    </xsl:template>
    
    
    <xsl:template match="ol" mode="javadoc">
     &lt;ol><xsl:apply-templates select="node()"  mode="javadoc"/>&lt;/ol>
    </xsl:template>
    
    <xsl:template match="ul" mode="javadoc">
     &lt;ul><xsl:apply-templates select="node()"  mode="javadoc"/>&lt;/ul>
    </xsl:template>
    
    
    <xsl:template match="li" mode="javadoc">
     &lt;li><xsl:apply-templates select="node()" mode="javadoc"/>&lt;/li>
    </xsl:template>
    
    <xsl:template match="em" mode="javadoc">
     &lt;em><xsl:apply-templates select="node()" mode="javadoc"/>&lt;/em>
    </xsl:template>
    
    
    <xsl:template match="must" mode="javadoc">
     &lt;p>This violation has &lt;a href="http://www.apps.ietf.org/rfc/rfc2119.html#sec-1">MUST&lt;/a> force.&lt;/p>
    </xsl:template>
    
    <xsl:template match="should" mode="javadoc">
     &lt;p>This violation has &lt;a href="http://www.apps.ietf.org/rfc/rfc2119.html#sec-1">SHOULD&lt;/a> force.
     By default, this is treated as an error (for the relevant specs), but that behaviour can be modified by
     {@link IRIFactory#shouldViolation}.
     &lt;/p>
    </xsl:template>
    
    
    <xsl:template match="security" mode="javadoc">
     &lt;p>This violation may indicate security issues, and the behaviour of a factory
     implementing the relevant specs can be modified by
     {@link IRIFactory#securityViolation}.
     &lt;/p>
    </xsl:template>
    
    
    <xsl:template match="violation/dns" mode="javadoc">
     &lt;p>This violation is relevant for IRIs using DNS as the registry of hostnames.
     The behaviour of a factory
     implementing the relevant specs can be modified by
     {@link IRIFactory#dnsViolation}.
     &lt;/p>
    </xsl:template>
    
    
    <xsl:template match="scheme/dns" mode="javadoc">
     &lt;br/>
     This scheme requires the use of hostnames conforming to DNS syntax.
     The IDNA compatibile processing of IRIs for this scheme is enabled if this scheme is enabled.
     To disable this behaviour, this scheme has to be disabled using // TODO how to disable scheme
     and DNS compatibile rules have to be disabled using {@link IRIFactory#dnsViolation}.
    </xsl:template>
    
    <xsl:template match="minting" mode="javadoc">
     &lt;p>This violation relates to creating your own IRIs, rather than
     accepting and processing other peoples', and the behaviour of a factory
     implementing the relevant specs can be modified by
     {@link IRIFactory#mintingViolation}.
     &lt;/p>
    </xsl:template>
    
    
    <!--
    <xsl:template match="bad|good[not(unicode)]" mode="javadoc">
     &lt;li>&amp;lt;&lt;code><xsl:value-of select="."/>&lt;/code>>&lt;/li>
    </xsl:template>
    -->
    
    <xsl:template match="bad|good" mode="javadoc">
     &lt;li>&amp;lt;&lt;code><xsl:apply-templates select="node()" mode="javadoc"/>&lt;/code>>&lt;/li>
    </xsl:template>
    
    <xsl:template match="unicode" mode="javadoc">
      <xsl:text>\u</xsl:text><xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template match="see" mode="javadoc">
     @see <xsl:value-of select="."/>
    </xsl:template>
    
    <xsl:template match="specification|scheme" mode="javadoc">
      &lt;dt>&lt;a name="ref-<xsl:value-of select="@id"/>">[<xsl:value-of select="@id"/>]&lt;/a>
      <xsl:if test="@rfc">
      RFC <xsl:value-of select="@rfc"/>
      </xsl:if>
      &lt;/dt>
      &lt;dd>&lt;a href="<xsl:apply-templates select="." mode="url"/>">
      <xsl:value-of select="name"/>
      <xsl:if test="section or @section">
        (section <xsl:value-of select="section|@section"/>)
      </xsl:if>&lt;/a>
      &lt;/dd>
      <xsl:if test="defn">
      &lt;dd>
      Pertinent text from the specification includes:
      &lt;br />
      &lt;dl>
      <xsl:apply-templates select="defn" mode="javadoc"/>
      &lt;/dl>
      &lt;/dd>
      </xsl:if>
      <xsl:if test="*[not(self::name) and not(self::section) and not(self::complete)]">
      &lt;dd><xsl:apply-templates select="*[not(self::bad)][not(self::good)][not(self::defn)]" mode="javadoc"/>
      <xsl:if test="good">
             &lt;br/>
             The following are examples of well-formed IRIs using this scheme:
             &lt;ul>
             <xsl:apply-templates select="good" mode="javadoc"/>
             &lt;/ul>
             </xsl:if>       
      <xsl:if test="bad">
             &lt;br/>
             The following are examples of ill-formed IRIs using this scheme:
             &lt;ul>
             <xsl:apply-templates select="bad" mode="javadoc"/>
             &lt;/ul>
             </xsl:if>
      &lt;/dd>
      </xsl:if>
    </xsl:template>
    
    <xsl:template match="name" mode="javadoc"/>
    <xsl:template match="section" mode="javadoc"/>
    <xsl:template match="complete" mode="javadoc"/>
    
    <xsl:template match="port" mode="javadoc">
      The default port is <xsl:value-of select="."/>.&lt;br />
    </xsl:template>
    
    <xsl:template match="prohibit" mode="javadoc">
      The <xsl:value-of select="@component"/> component must be omitted.&lt;br />
    </xsl:template>
    
    <xsl:template match="require" mode="javadoc">
      The <xsl:value-of select="@component"/> component is required.&lt;br />
    </xsl:template>
    
    <xsl:template match="todo" mode="javadoc">
      <xsl:text>&lt;br/>TODO: </xsl:text>
      <xsl:apply-templates select="node()" mode="javadoc"/>
    </xsl:template>
    
    
    <xsl:template match="pattern[text()][@reserved]" mode="javadoc">
      The <xsl:value-of select="@component"/> component:
      &lt;ul>
      &lt;li>
      is required to match the regular expression: <xsl:apply-templates mode="javadoc" select="node()"/>
      &lt;/li>
      &lt;li>
      may use <xsl:value-of select="@reserved"/> as sub-delimiters, and care must
      be taken when percent escaping or unescaping these delimiters to not disrupt
      the scheme specific syntax.
      &lt;/li>
      &lt;/ul>
    </xsl:template>
    
    <xsl:template match="pattern[not(text())][@reserved]" mode="javadoc">
      The <xsl:value-of select="@component"/> component
      may use <xsl:value-of select="@reserved"/> as sub-delimiters, and care must
      be taken when percent escaping or unescaping these delimiters to not disrupt
      the scheme specific syntax. &lt;br/>
    </xsl:template>
     
    <xsl:template match="pattern[text()][not(@reserved)]" mode="javadoc">
      The <xsl:value-of select="@component"/> component
      is required to match the regular expression: <xsl:apply-templates mode="javadoc" select="node()"/>
      &lt;br/>
    </xsl:template>
    
     <xsl:template match="*[@section]" mode="javadoc-link">
       <xsl:text>&lt;a href="</xsl:text>
       <xsl:apply-templates select="." mode="url"/>
       <xsl:text>">section </xsl:text>
       <xsl:value-of select="@section"/>
       <xsl:text>&lt;a></xsl:text>
     </xsl:template>
          
     
      <xsl:template match="*" mode="javadoc-link">
       <xsl:text>&lt;a href="</xsl:text>
       <xsl:apply-templates select="." mode="url"/>
       <xsl:text>">here&lt;a></xsl:text>
     </xsl:template>
     
     
     <xsl:template match="*[@fragment]" mode="url">
       <xsl:call-template name="bareURI"/>
       <xsl:text>#</xsl:text>
       <xsl:value-of select="@fragment"/>
     </xsl:template>
     
     
     <xsl:template match="*[@section]" mode="url">
       <xsl:call-template name="bareURI"/>
       <xsl:text>#sec-</xsl:text>
       <xsl:value-of select="@section"/>
     </xsl:template>
          
     <xsl:template match="*" mode="url">
       <xsl:apply-templates mode="rawUrl" select="."/>
     </xsl:template>
     
     <xsl:template match="*[@href]" mode="rawUrl">
       <xsl:value-of select="@href"/>
     </xsl:template>
     
     
     <xsl:template match="*[@rfc and @rfc &gt; 4000]" mode="rawUrl">
       <xsl:text>http://www.ietf.org/rfc/rfc</xsl:text>
       <xsl:value-of select="@rfc"/>
       <xsl:text>.txt</xsl:text>
     </xsl:template>
     
     
     
     <xsl:template match="*[@rfc and @rfc &lt;= 4000]" mode="rawUrl">
       <xsl:text>http://www.apps.ietf.org/rfc/rfc</xsl:text>
       <xsl:value-of select="@rfc"/>
       <xsl:text>.html</xsl:text>
     </xsl:template>
     
     
     
     
     <xsl:template match="*[../@ref or @ref]" mode="rawUrl">
       <xsl:apply-templates select="id(../@ref|@ref)" mode="url" />
     </xsl:template>
     
     <xsl:template match="*[../@id]" mode="rawUrl">
       <xsl:apply-templates select=".." mode="url" />
     </xsl:template>
     
     
     <xsl:template match="require/text|prohibit/text" mode="rawUrl">
       <xsl:apply-templates select=".." mode="url" />
     </xsl:template>
     
     <!--
     <xsl:template match="*" mode="url">
       <xsl:message>No match.</xsl:message>
     </xsl:template>
     -->
     <xsl:template name="bareURI">
       <xsl:variable name="uriWithFrag">
         <xsl:apply-templates select="." mode="rawUrl"/>
       </xsl:variable>
            <xsl:if test="contains($uriWithFrag,'#')">
                <xsl:value-of select="substring-before($uriWithFrag,'#')"/>
                
            </xsl:if>
            <xsl:if test="not(contains($uriWithFrag,'#'))">
                <xsl:value-of select="$uriWithFrag"/>
            </xsl:if>
     </xsl:template>
    
     
     <xsl:template match="spec[@fragment or @section]|also[@fragment or @section]" mode="javadoc-spec-list">
          <xsl:text>&lt;a href="#ref-</xsl:text>
          <xsl:value-of select="@ref"/>
          <xsl:text>">[</xsl:text>
          <xsl:value-of select="@ref"/>
          <xsl:text>]&lt;/a> (see </xsl:text>
          <xsl:apply-templates select="." mode="javadoc-link"/>
          <xsl:text>)</xsl:text>
          <xsl:if test="not(position()=last())">, </xsl:if>
    </xsl:template>
    
     <xsl:template match="spec|also" mode="javadoc-spec-list">
          <xsl:text>&lt;a href="#ref-</xsl:text>
          <xsl:value-of select="@ref"/>
          <xsl:text>">[</xsl:text>
          <xsl:value-of select="@ref"/>
          <xsl:text>]&lt;/a></xsl:text>
          <xsl:if test="not(position()=last())">, </xsl:if>
    </xsl:template>
    <xsl:template match="violation[name/text()='PROHIBITED_COMPONENT_PRESENT']" mode="require-prohibit">
          <xsl:apply-templates select="//prohibit" mode="require-prohibit"/>                       
    </xsl:template>
    <xsl:template match="violation[name/text()='REQUIRED_COMPONENT_MISSING']" mode="require-prohibit">
          <xsl:apply-templates select="//require" mode="require-prohibit"/>                       
    </xsl:template>
     <xsl:template match="violation[name/text()='PROHIBITED_COMPONENT_PRESENT' 
                                 or name/text()='REQUIRED_COMPONENT_MISSING']" mode="static" priority="10">
            new ViolationCodeInfo(
                <xsl:value-of select= "name"/>,
                "<xsl:value-of select= "name"/>",
                "<xsl:apply-templates select="description" mode="java-string"/>",
                "<xsl:apply-templates select="description" mode="java-html-string"/>",
                0<xsl:apply-templates select="(should|minting|must|dns|security)" mode="force"/>,
                new InSpec[]{
                  <xsl:apply-templates select="." mode="require-prohibit"/>
                },
                new String[]{
                  <xsl:apply-templates select="bad" mode="static"/>
                },
                
                new String[]{
                  <xsl:apply-templates select="good" mode="static"/>
                },
                <xsl:if test="unimplemented">true||</xsl:if>
                false
            );
    </xsl:template>
       
    <xsl:template match="violation[description]" mode="static" priority="1">
            new ViolationCodeInfo(
                <xsl:value-of select= "name"/>,
                "<xsl:value-of select= "name"/>",
                "<xsl:apply-templates select="description" mode="java-string"/>",
                "<xsl:apply-templates select="description" mode="java-html-string"/>",
                0<xsl:apply-templates select="(should|minting|must|dns|security)" mode="force"/>,
                new InSpec[]{
                  <xsl:apply-templates select="(spec|also)" mode="static"/>
                },
                new String[]{
                  <xsl:apply-templates select="bad" mode="static"/>
                },
                
                new String[]{
                  <xsl:apply-templates select="good" mode="static"/>
                },
                <xsl:if test="unimplemented">true||</xsl:if>
                false
            );
    </xsl:template>
    
     <xsl:template match="scheme" mode="static">
     spec =
       new SchemeSpecification(
                "<xsl:value-of select= "@id"/>",
                "<xsl:value-of select= "@rfc"/>",
                "<xsl:apply-templates select="." mode="url"/>",
                "<xsl:call-template name="escape-java-string">
            <xsl:with-param name="t" select="normalize-space(name)"/>
                  </xsl:call-template>",
                "<xsl:value-of select="@section"/>",
                
                new String[]{
                  <xsl:apply-templates select="bad" mode="static"/>
                },
                
                new String[]{
                  <xsl:apply-templates select="good" mode="static"/>
                }
            );
            
            <xsl:apply-templates select="*[not(self::good or self::bad)]" mode="static"/>
    </xsl:template>
    
    <xsl:template match="specification" mode="static">
     spec =
       new Specification(
                "<xsl:value-of select= "@id"/>",
                "<xsl:value-of select= "@type"/>",
                "<xsl:value-of select= "@rfc"/>",
                "<xsl:apply-templates select="." mode="url"/>",
                "<xsl:call-template name="escape-java-string">
            <xsl:with-param name="t" select="normalize-space(name)"/>
                  </xsl:call-template>",
                "<xsl:call-template name="escape-java-string">
            <xsl:with-param name="t" select="normalize-space(section)"/>
                  </xsl:call-template>",
                  
                new String[]{
                  <xsl:apply-templates select="bad" mode="static"/>
                },
                
                new String[]{
                  <xsl:apply-templates select="good" mode="static"/>
                }
            );
            <xsl:apply-templates select="*[not(self::good or self::bad)]" mode="static"/>
    </xsl:template>
    
    <xsl:template match="defn" mode="static" >
        spec
        <xsl:text>.addDefinition(
                "</xsl:text>
        <xsl:apply-templates select="." mode="url"/>
        <xsl:text>",    
                "</xsl:text>
        <xsl:apply-templates select="node()" mode="java-string"/>
        <xsl:text>",    
                "</xsl:text>
        <xsl:apply-templates select="node()" mode="java-html-string"/>
        <xsl:text>"</xsl:text>
        );
    </xsl:template>
    
    <xsl:template match="name" mode="static" />
    
    <xsl:template match="todo" mode="static" />
    
    <xsl:template match="section" mode="static" />
    
    <xsl:template match="complete" mode="static" />
    
    <xsl:template match="dns" mode="static" >
        spec.setDNS(true);
    </xsl:template>
    
    
    <xsl:template match="port" mode="static" >
        spec.port(<xsl:value-of select="."/>);
    </xsl:template>
    
    
    <xsl:template match="pattern" mode="static" >
      <xsl:if test="text()">
        spec.setPattern(<xsl:value-of select="@component"/>,
                "<xsl:call-template name="escape-java-string">
            <xsl:with-param name="t" select="text()"/>
                  </xsl:call-template>" );
      </xsl:if>
      <xsl:if test="@reserved">
        spec.setReserved(<xsl:value-of select="@component"/>,"<xsl:value-of select="@reserved"/>");
      </xsl:if>
    </xsl:template>
    
    
    <xsl:template match="prohibit|require" mode="static" >
        spec.<xsl:value-of select="name()"/>(
              IRIComponents.<xsl:value-of select="@component"/>
        );
    </xsl:template>
    
    <xsl:template match="violation" mode="static">
            new ViolationCodeInfo(
                <xsl:value-of select= "name"/>,
                "<xsl:value-of select= "name"/>",
                new String[]{
                  <xsl:apply-templates select="bad" mode="static"/>
                },
                new String[]{
                  <xsl:apply-templates select="good" mode="static"/>
                },
                <xsl:if test="internal">true||</xsl:if>
                false
            );
    </xsl:template>
    
    <!--
    <xsl:template match="spec[text/@component]" mode="static">
       <xsl:apply-templates select="text" mode="static"/>
    </xsl:template>
    -->
    
    <xsl:template match="spec" mode="static">
      <xsl:apply-templates select="text" mode="static"/>
    </xsl:template>
    
    
    
    
    <xsl:template match="require[not(text)]|prohibit[not(text)]" mode="require-prohibit">
       new FromSpec_<xsl:value-of select= "../@type"/>(
                "<xsl:value-of select="../@id"/>", 
                <xsl:value-of select="@component"/>,
                "<xsl:apply-templates select="." mode="url"/>"
            ),
    </xsl:template>
    <xsl:template match="require[text]|prohibit[text]" mode="require-prohibit">
       <xsl:apply-templates select="text" mode="require-prohibit"/>
    </xsl:template>
    
    <xsl:template match="require/text|prohibit/text" mode="require-prohibit">
       new FromSpec_<xsl:value-of select= "../../@type"/>(
                "<xsl:value-of select="../../@id"/>", 
                <xsl:value-of select="../@component"/>,
                "<xsl:apply-templates select="." mode="url"/>",
                "<xsl:apply-templates select="." mode="java-string"/>",
                "<xsl:apply-templates select="." mode="java-html-string"/>"
            ),
    </xsl:template>
    
    
    <xsl:template match="text" mode="static">
       new FromSpec_<xsl:value-of select= "id(../@ref)/@type"/>(
                "<xsl:value-of select="../@ref"/>", 
                <xsl:if test="@component">
                  <xsl:value-of select="@component"/>
                </xsl:if>
                <xsl:if test="not(@component)">
                  <xsl:text>-1</xsl:text>
                </xsl:if>
                <xsl:text>,</xsl:text>
                "<xsl:apply-templates select="." mode="url"/>",
                "<xsl:apply-templates select="." mode="java-string"/>",
                "<xsl:apply-templates select="." mode="java-html-string"/>"
            ),
    </xsl:template>
    
            
    
    <xsl:template match="also" mode="static">
            new FromAlso(
                "<xsl:value-of select= "@ref"/>",
                "<xsl:apply-templates select="." mode="url"/>"
            ),
    </xsl:template>
    
    
                      
    <xsl:template match="*" mode="force">
      <xsl:text>|Force.</xsl:text>
      <xsl:value-of select="name(.)"/>
    </xsl:template>
    
    
    <xsl:template match="description|text" mode="java-string">
       <xsl:apply-templates select="node()" mode="java-string"/>
     </xsl:template>
     
     <!-- normalize space, and replace any \ by \\ -->
    <xsl:template match="text()" mode="java-string">
       <xsl:call-template name="escape-java-string">
         <xsl:with-param name="t" select="normalize-space(.)"/>
       </xsl:call-template>
     </xsl:template>
     
     <xsl:template match="text()" mode="java-string-not-normalized">
       <xsl:call-template name="escape-java-string">
         <xsl:with-param name="t" select="."/>
       </xsl:call-template>
     </xsl:template>
     <xsl:template match="unicode" mode="java-string-not-normalized">
       <xsl:apply-templates select="." mode="java-string"/>
     </xsl:template>
     
     <xsl:template name="translate">
        <xsl:param name="string"/>
        <xsl:param name="rules"/>
        <xsl:if test="$rules=''">
          <xsl:value-of select="$string"/>
        </xsl:if>
        <xsl:if test="not($rules='')">
           <xsl:variable name="search" select="substring-before($rules,';')"/>
           <xsl:variable name="replace" select="substring-after(substring-before($rules,':'),';')" />
           <xsl:variable name="rules-tail" select="substring-after($rules,':')"/>
           
           <xsl:if test="not(contains($string,$search))">
                <xsl:call-template name="translate">
                     <xsl:with-param name="string" select="$string"/>
                     <xsl:with-param name="rules" select="$rules-tail"/>
                </xsl:call-template>
           </xsl:if>
           
           <xsl:if test="contains($string,$search)">
                <xsl:call-template name="translate">
                     <xsl:with-param name="string" select="substring-before($string,$search)"/>
                     <xsl:with-param name="rules" select="$rules-tail"/>
                </xsl:call-template>
                <xsl:value-of select="$replace"/>
                <xsl:call-template name="translate">
                     <xsl:with-param name="string" select="substring-after($string,$search)"/>
                     <xsl:with-param name="rules" select="$rules"/>
                </xsl:call-template>
           </xsl:if>
        </xsl:if>
     
     </xsl:template>
     
     <xsl:variable name="java-string-rules">";\":&#x2028;;\n"+
    ":\;\\:</xsl:variable>
    
     <xsl:variable name="java-html-string-rules">";\":&#x2028;;\n"+
    ":\;\\:&lt;;&amp;lt;:</xsl:variable>
    
     <xsl:template name="escape-java-string">
      <xsl:param name="t"/>
                <xsl:call-template name="translate">
                     <xsl:with-param name="string" select="$t"/>
                     <xsl:with-param name="rules" select="$java-string-rules"/>
                </xsl:call-template>
     </xsl:template>
     
     
     <xsl:template name="escape-java-html-string">
      <xsl:param name="t"/>
                <xsl:call-template name="translate">
                     <xsl:with-param name="string" select="$t"/>
                     <xsl:with-param name="rules" select="$java-html-string-rules"/>
                </xsl:call-template>
     </xsl:template>
     
<!--    2028; LINE SEPARATOR -->
    <xsl:template match="pre" mode="java-string">
       <xsl:text>"+
  "</xsl:text>
          <xsl:call-template name="escape-java-string">
            <xsl:with-param name="t" select="translate(text(),'&#xA;','&#x2028;')"/>
          </xsl:call-template>
    </xsl:template>
    
    <xsl:template match="ol|ul" mode="java-string">
      <xsl:apply-templates select="li"  mode="java-string"/>
      <xsl:text> </xsl:text>
    </xsl:template>
    
    
    <xsl:template match="li" mode="java-string">
      <xsl:text> (</xsl:text>
      <xsl:value-of select="count(self|preceding-sibling::li)"/>
      <xsl:text>)</xsl:text>
      <xsl:apply-templates select="node()" mode="java-string"/>
    </xsl:template>
    
    <xsl:template match="em" mode="java-string">
     <xsl:text> *</xsl:text>
     <xsl:apply-templates select="node()" mode="java-string"/>
     <xsl:text>* </xsl:text>
    </xsl:template>
    
    <xsl:template match="bad|good" mode="static">
      "<xsl:apply-templates select="node()" mode="java-string-not-normalized"/>",
    </xsl:template>
    
    <xsl:template match="unicode[text()='000A']" mode="java-string">
      <xsl:text>\n</xsl:text>
    </xsl:template>
    
    <xsl:template match="unicode[text()='000D']" mode="java-string">
      <xsl:text>\r</xsl:text>
    </xsl:template>
    
    <xsl:template match="unicode" mode="java-string">
      <xsl:text>\u</xsl:text>
      <xsl:value-of select="text()"/>
    </xsl:template>
    
    
    <xsl:template match="description|text" mode="java-html-string">
       <xsl:text>&lt;p></xsl:text>
       <xsl:apply-templates select="node()" mode="java-html-string"/>
       <xsl:text>&lt;/p></xsl:text>
     </xsl:template>
     
    <xsl:template match="text()" mode="java-html-string">
       <xsl:call-template name="escape-java-html-string">
         <xsl:with-param name="t" select="normalize-space(.)"/>
       </xsl:call-template>
     </xsl:template>
    
    <xsl:template match="ol|ul" mode="java-html-string">
     <xsl:text>"+
     "&lt;/p>&lt;</xsl:text>
     <xsl:value-of select="name(.)"/>
     <xsl:text>&gt;</xsl:text>
      <xsl:apply-templates select="li"  mode="java-html-string"/>
       <xsl:text>&lt;/</xsl:text>
     <xsl:value-of select="name(.)"/>
     <xsl:text>&gt;"+
     "&lt;p></xsl:text>
    </xsl:template>
    
    
    
    <xsl:template match="pre" mode="java-html-string">
     <xsl:text>"+
     "&lt;/p>&lt;</xsl:text>
     <xsl:value-of select="name(.)"/>
     <xsl:text>&gt;</xsl:text>
       <xsl:call-template name="escape-java-html-string">
         <xsl:with-param name="t" select="translate(text(),'&#xA;','&#x2028;')"/>
       </xsl:call-template>
     <xsl:text>&lt;/</xsl:text>
     <xsl:value-of select="name(.)"/>
     <xsl:text>&gt;"+
     "&lt;p></xsl:text>
    </xsl:template>
    
    <xsl:template match="em|li" mode="java-html-string">
     <xsl:text>"+
     " &lt;</xsl:text>
     <xsl:value-of select="name(.)"/>
     <xsl:text>&gt;</xsl:text>
     <xsl:apply-templates select="node()" mode="java-html-string"/>
     <xsl:text>&lt;/</xsl:text>
     <xsl:value-of select="name(.)"/>
     <xsl:text>&gt; "+
     "</xsl:text>
    </xsl:template>
    
</xsl:stylesheet>
