/*
  Copyright (C) 2008 André Gaul

        This file is part of mmpong.

        mmpong is free software: you can redistribute it and/or modify
        it under the terms of the GNU General Public License as published by
        the Free Software Foundation, either version 3 of the License, or
        (at your option) any later version.

        mmpong is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU General Public License for more details.

        You should have received a copy of the GNU General Public License
        along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <cstring>
#include <stdlib.h>
#include "resource.h"

#if defined(__APPLE__)
	// Mac OS X: resources are located in app bundle 
	// (create path from argv[0])
#	define RESOURCE_MAXLEN 256
	const char * get_resource(const char *name) {
		static char * respath = NULL;
		static int respathlen;

		if (!name)
			return NULL;

		if (!respath && name) {
			respath=(char*)malloc(sizeof(char)*(strlen(name) + RESOURCE_MAXLEN));
			if (!respath)
				return NULL;
			else {
				respathlen=strlen(name);
				strncpy(respath, name, respathlen+1);
				return respath;
			}
		}

		strncpy(respath+respathlen, name, RESOURCE_MAXLEN);
		respath[respathlen+RESOURCE_MAXLEN-1]='\0';
		
		return respath;
	}
# undef RESOURCE_MAXLEN

#endif

