/*	PVL

CVS ID: PVL.java,v 1.8 2012/04/16 06:14:23 castalia Exp

Copyright (C) 2003-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.PVL.*;
import	PIRL.Utilities.Streams;

import	java.io.File;


public class PVL
{

public static void main (String[] arguments) 
{
if (arguments.length == 0)
	Usage ();

try {

String
	source = null;
Parameter
	selection = new Parameter ();
Selector
	criteria = new Selection ();
boolean
	indent = true,
	strict = false,
	select = false,
	quiet  = false;

for (int argument = 0;
	 argument < arguments.length;
	 argument++)
	{
	if (arguments[argument].startsWith ("-") &&
		arguments[argument].length () > 1)
		{
		switch (arguments[argument].charAt (1))
			{
			case 'n':
			case 'f':
				criteria.Specific (false);
			case 'N':
			case 'F':
				select = true;
				criteria.Name (true);
				if (++argument == arguments.length)
					Usage ();
				selection.Name (arguments[argument]);
				break;

			case 'C':
			case 'c':
				select = true;
				criteria.Classification (true);
				if (++argument == arguments.length)
					Usage ();
				System.out.println ("Classification = " + arguments[argument]);
				switch (arguments[argument].charAt (0))
					{
					case 'A':
					case 'a':
						criteria.Specific (false);
						if (arguments[argument].charAt (1) == 'G' ||
							arguments[argument].charAt (1) == 'g')
							selection.Classification (Parameter.GROUP);
						else
							selection.Classification (Parameter.ASSIGNMENT);
						break;
					case 'G':
					case 'g':
						criteria.Specific (true);
						selection.Classification (Parameter.GROUP);
						break;
					case 'O':
					case 'o':
						criteria.Specific (true);
						selection.Classification (Parameter.OBJECT);
						break;
					case 'T':
					case 't':
						selection.Classification (Parameter.TOKEN);
						break;
					case 'U':
					case 'u':
						selection.Classification (Parameter.UNKNOWN);
						break;
					default:
						Usage ();
					}
				break;
			case 'v':
				criteria.Specific (false);
			case 'V':
				select = true;
				criteria.Value (true).Data (true);
				if (++argument == arguments.length)
					Usage ();
				Parser value_string = new Parser (arguments[argument]);
				selection.Value
					(new Parser (arguments[argument]).Get_Value ());
				break;

			case 'A':
			case 'a':
				if (! arguments[argument].equalsIgnoreCase ("-AND"))
					Usage ();
				criteria.And (true);
				break;
			case 'O':
			case 'o':
				if (! arguments[argument].equalsIgnoreCase ("-OR"))
					Usage ();
				criteria.And (false);
				break;
			case 'I':
			case 'i':
				indent = false;
				if ((argument + 1) < arguments.length &&
					arguments[argument + 1].charAt (0) != '-')
					{
					argument++;
					if (arguments[argument].indexOf ('N') >= 0 ||
						arguments[argument].indexOf ('n') >= 0)
						indent = true;
					}
				break;
			case 'S':
			case 's':
				strict = true;
				if ((argument + 1) < arguments.length &&
					arguments[argument + 1].charAt (0) != '-')
					{
					argument++;
					if (arguments[argument].indexOf ('F') >= 0 ||
						arguments[argument].indexOf ('f') >= 0)
						strict = false;
					}
				break;
			case 'P':
			case 'p':
				criteria.Pattern_Match (true);
				break;
			case 'Q':
			case 'q':
				quiet = true;
				break;
			default:
				System.err.println ("Unknown option: " + arguments[argument]);
			case 'H':
			case 'h':
				Usage ();
			}
		}
	else if (source == null)
		source = arguments[argument];
	else
		{
		System.err.println
			("Multiple PVL sources -\n"
			+ source + '\n'
			+"and\n"
			+ arguments[argument]);
		Usage ();
		}
	}
if (source == null)
	{
	System.err.println ("A PVL source must be specified.");
	Usage ();
	}

//	Ingest:
Parameter
	parameter =
		new Parameter
			(
			source,
			new Parser (Streams.Get_Stream (source))
			);

if (parameter.Warning () != null)
	{
	if (parameter.Warning ().Message ().equals
			(PVL_Exception.SIZED_RECORDS))
		System.out.println (parameter.Warning ());
	else
		System.out.println
			(
			">>> WARNING <<<\n" +
			parameter.Warning ().getMessage () + "\n"
			);
	}

if (select)
	{
	String
		name;
	Parameter
		param = null;
	while ((param = parameter.Find (selection, criteria, param)) != null)
		{
		name = param.Name ();
		param.Name
			(param.Path_to_Name ().substring (source.length () + 1) + name);
		if (quiet)
			param.Comments (null);
		param.Write (indent, strict);
		param.Name (name);
		}
	}
else
	{
	parameter.Write (indent, strict);
	new Parameter ().Classification (Parameter.END_PVL).Write ();
	}
}	//	try
catch (Exception exception)
	{
	System.out.println ("PVL error -\n" + exception.getMessage () + "\n");
	System.exit (-1);
	}
System.exit (0);
}


private static void Usage ()
{
System.err.println
	(
	"Usage: java PVL [options] <PVL source>\n"
	+ "  Options -\n"
	+ "  -Name | -Find <name>\n"
	+ "    -Name or -Find is case sensitive\n"
	+ "    -name or -find is case insensitive\n"
	+ "  -Classification <type>\n"
	+ "    The <type> is AGgregate, Group, Object, Assignment, Token or Unknown\n"
	+ "  -Value <value>\n"
	+ "  -AND|OR [or]\n"
	+ "  -Pattern\n"
	+ "    Comparison <name> or <value> strings are regular expressions\n"
	+ "  -Indent [oFf | oN] (on)\n"
	+ "  -Strict [oN | oFf] (off)\n"
	+ "  -Quiet\n"
	+ "    Suppress comments of selected parameters\n"
	+ "  -Help\n"
	);

System.exit (1);
}


}
