/*
 * Copyright 2013 Canonical Ltd.
 *
 * This file is part of powerd.
 *
 * powerd is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * powerd is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __POWERD_OBJECT_H__
#define __POWERD_OBJECT_H__

#include <glib-object.h>

#ifdef __cplusplus
extern "C" {
#endif

G_BEGIN_DECLS

#define POWERD_TYPE_SOURCE            (powerd_source_get_type ())
#define POWERD_SOURCE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), POWERD_TYPE_SOURCE, PowerdSource))
#define POWERD_IS_SOURCE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), POWERD_TYPE_SOURCE))
#define POWERD_SOURCE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), POWERD_TYPE_SOURCE, PowerdSourceClass))
#define POWERD_IS_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), POWERD_TYPE_SOURCE))
#define POWERD_SOURCE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), POWERD_TYPE_SOURCE, PowerdSourceClass))

struct _PowerdSourcePrivate;

typedef struct _PowerdSource         PowerdSource;
typedef struct _PowerdSourceClass    PowerdSourceClass;
typedef struct _PowerdSourcePrivate  PowerdSourcePrivate;

struct _PowerdSourceClass {
	GObjectClass parent_class;
};

struct _PowerdSource {
	GObject parent;
	PowerdSourcePrivate * priv;
};

GType                    powerd_source_get_type          (void);

G_END_DECLS

#ifdef __cplusplus
}
#endif

#endif
