# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum, EnumMeta
from six import with_metaclass

class _CaseInsensitiveEnumMeta(EnumMeta):
    def __getitem__(self, name):
        return super().__getitem__(name.upper())

    def __getattr__(cls, name):
        """Return the enum member matching `name`
        We use __getattr__ instead of descriptors or inserting into the enum
        class' __dict__ in order to support `name` and `value` being both
        properties for enum members (which live in the class' __dict__) and
        enum members themselves.
        """
        try:
            return cls._member_map_[name.upper()]
        except KeyError:
            raise AttributeError(name)


class ChangeDetectionMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Change Detection Mode. Applies to a directory specified in directoryPath parameter.
    """

    DEFAULT = "Default"
    RECURSIVE = "Recursive"

class FeatureStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the Feature Status
    """

    ON = "on"
    OFF = "off"

class IncomingTrafficPolicy(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the Incoming Traffic Policy
    """

    ALLOW_ALL_TRAFFIC = "AllowAllTraffic"
    ALLOW_VIRTUAL_NETWORKS_ONLY = "AllowVirtualNetworksOnly"

class InitialDownloadPolicy(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Policy for how namespace and files are recalled during FastDr
    """

    NAMESPACE_ONLY = "NamespaceOnly"
    NAMESPACE_THEN_MODIFIED_FILES = "NamespaceThenModifiedFiles"
    AVOID_TIERED_FILES = "AvoidTieredFiles"

class LocalCacheMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Policy for enabling follow-the-sun business models: link local cache to cloud behavior to pre-
    populate before local access.
    """

    DOWNLOAD_NEW_AND_MODIFIED_FILES = "DownloadNewAndModifiedFiles"
    UPDATE_LOCALLY_CACHED_FILES = "UpdateLocallyCachedFiles"

class NameAvailabilityReason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Gets the reason that a Storage Sync Service name could not be used. The Reason element is only
    returned if NameAvailable is false.
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class OperationDirection(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the Operation Direction
    """

    DO = "do"
    UNDO = "undo"
    CANCEL = "cancel"

class PrivateEndpointConnectionProvisioningState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The current provisioning state.
    """

    SUCCEEDED = "Succeeded"
    CREATING = "Creating"
    DELETING = "Deleting"
    FAILED = "Failed"

class PrivateEndpointServiceConnectionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """The private endpoint connection status.
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"

class ProgressType(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the ProgressType
    """

    NONE = "none"
    INITIALIZE = "initialize"
    DOWNLOAD = "download"
    UPLOAD = "upload"
    RECALL = "recall"

class Reason(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """State of Azure Subscription
    """

    REGISTERED = "Registered"
    UNREGISTERED = "Unregistered"
    WARNED = "Warned"
    SUSPENDED = "Suspended"
    DELETED = "Deleted"

class RegisteredServerAgentVersionStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the registered server agent version status
    """

    OK = "Ok"
    NEAR_EXPIRY = "NearExpiry"
    EXPIRED = "Expired"
    BLOCKED = "Blocked"

class ServerEndpointHealthState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the server endpoint health state
    """

    UNAVAILABLE = "Unavailable"
    HEALTHY = "Healthy"
    ERROR = "Error"

class ServerEndpointOfflineDataTransferState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the Health state
    """

    IN_PROGRESS = "InProgress"
    STOPPING = "Stopping"
    NOT_RUNNING = "NotRunning"
    COMPLETE = "Complete"

class ServerEndpointSyncActivityState(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the sync activity state
    """

    UPLOAD = "Upload"
    DOWNLOAD = "Download"
    UPLOAD_AND_DOWNLOAD = "UploadAndDownload"

class ServerEndpointSyncMode(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Sync mode for the server endpoint.
    """

    REGULAR = "Regular"
    NAMESPACE_DOWNLOAD = "NamespaceDownload"
    INITIAL_UPLOAD = "InitialUpload"
    SNAPSHOT_UPLOAD = "SnapshotUpload"
    INITIAL_FULL_DOWNLOAD = "InitialFullDownload"

class WorkflowStatus(with_metaclass(_CaseInsensitiveEnumMeta, str, Enum)):
    """Type of the Workflow Status
    """

    ACTIVE = "active"
    EXPIRED = "expired"
    SUCCEEDED = "succeeded"
    ABORTED = "aborted"
    FAILED = "failed"
