# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CheckGroupMembershipParameters(Model):
    """Request parameters for IsMemberOf API call.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param group_id: Required. The object ID of the group to check.
    :type group_id: str
    :param member_id: Required. The object ID of the contact, group, user, or
     service principal to check for membership in the specified group.
    :type member_id: str
    """

    _validation = {
        'group_id': {'required': True},
        'member_id': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'group_id': {'key': 'groupId', 'type': 'str'},
        'member_id': {'key': 'memberId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckGroupMembershipParameters, self).__init__(**kwargs)
        self.additional_properties = kwargs.get('additional_properties', None)
        self.group_id = kwargs.get('group_id', None)
        self.member_id = kwargs.get('member_id', None)
