/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef UTILS_SYMBIAN_P_H
#define UTILS_SYMBIAN_P_H

#include <bttypes.h>
#include <bt_sock.h>

QT_BEGIN_HEADER

QTM_BEGIN_NAMESPACE

inline QBluetoothAddress qTBTDevAddrToQBluetoothAddress(const TBTDevAddr &address)
{
    return QBluetoothAddress(QString(QByteArray((const char *)address.Des().Ptr(), 6).toHex().toUpper()));
}
inline quint32 qTPackSymbianDeviceClass(const TInquirySockAddr &address)
{
    TUint8 minorClass = address.MinorClassOfDevice();
    TUint8 majorClass = address.MajorClassOfDevice();
    TUint16 serviceClass = address.MajorServiceClass();
    quint32 deviceClass = (0 << 2) | (minorClass << 6 ) | (majorClass <<5) | serviceClass;
    return deviceClass;
}
inline QString s60DescToQString(const TDesC &desc)
{
    return QString::fromUtf16(desc.Ptr(), desc.Length());
}
inline QByteArray s60Desc8ToQByteArray(const TDesC8 &desc)
{
    return QByteArray((const char*)desc.Ptr(), desc.Length());
}

QTM_END_NAMESPACE

QT_END_HEADER

#endif
