/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakecameracontrol.h"
#include "fakecameraservice.h"
#include "fakevideorenderercontrol.h"

FakeCameraControl::FakeCameraControl(FakeCameraService *service, QObject *parent)
   : QCameraControl(parent)
   , m_service(service)
   , m_state(QCamera::UnloadedState)
   , m_status(QCamera::ActiveStatus)
   , m_captureMode(QCamera::CaptureStillImage)
{
}

FakeCameraControl::~FakeCameraControl()
{
}

QCamera::State FakeCameraControl::state() const
{
    return m_state;
}

void FakeCameraControl::setState(QCamera::State state)
{
    if (m_state == state)
        return;

    m_state = state;
    Q_EMIT stateChanged(m_state);
}

QCamera::Status FakeCameraControl::status() const
{
    return m_status;
}

QCamera::CaptureModes FakeCameraControl::captureMode() const
{
    return m_captureMode;
}

void FakeCameraControl::setCaptureMode(QCamera::CaptureModes mode)
{
    if (m_captureMode == mode)
        return;

    m_captureMode = mode;
    Q_EMIT captureModeChanged(mode);
}

bool FakeCameraControl::isCaptureModeSupported(QCamera::CaptureModes mode) const
{
    return (QCamera::CaptureStillImage==mode) || (QCamera::CaptureVideo==mode);
}

bool FakeCameraControl::canChangeProperty(QCameraControl::PropertyChangeType changeType, QCamera::Status status) const
{
    Q_UNUSED(changeType);
    Q_UNUSED(status);

    return true;
}
