/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "noticeui.h"
#include <QVBoxLayout>
NoticeUi::NoticeUi(QWidget *parent) : QWidget(parent)
{
    initUi();
}

void NoticeUi::initUi()
{
    setMinimumSize(QSize(550, 0));
    setMaximumSize(QSize(16777215, 16777215));
    QVBoxLayout *vLyt = new QVBoxLayout(this);
    vLyt->setSpacing(0);
    vLyt->setContentsMargins(0, 0, 0, 0);

    mNoticeLabel = new TitleLabel;
    mNotFazeLabel = new TitleLabel;
    mNoticeLabel->setText(tr("Notice Settings"));
    mNotFazeLabel->setText(tr("NotFaze Mode"));

    UkccFrame *distrubFrame = new UkccFrame(this);
    distrubFrame->setFrameShape(QFrame::NoFrame);
    LightLabel *notFazeLabel = new LightLabel(tr("(Notification banners, prompts will be hidden, and notification sounds will be muted)"));
    QHBoxLayout *distrubLyt = new QHBoxLayout(distrubFrame);
    distrubLyt->setContentsMargins(0, 0, 0, 0);
    distrubLyt->addWidget(mNotFazeLabel);
    distrubLyt->addSpacing(4);
    distrubLyt->addWidget(notFazeLabel, Qt::AlignLeft);

    SettingGroup *notFazeFrame = new SettingGroup(this);
    initNotFaze(notFazeFrame);

    mGetNoticeWidget  = new SwitchWidget(tr("Get notifications from the app"));
    mApplistWidget = new SettingGroup;

    vLyt->setSpacing(8);
    vLyt->addWidget(distrubFrame);
    vLyt->addWidget(notFazeFrame);
    vLyt->addSpacing(24);
    vLyt->addWidget(mNoticeLabel);
    vLyt->addWidget(mGetNoticeWidget);
    vLyt->addWidget(mApplistWidget);
    vLyt->addStretch();
}

void NoticeUi::initNotFaze(SettingGroup *widget)
{
    UkccFrame *autoOpenFrame = new UkccFrame(widget, UkccFrame::BorderRadiusStyle::Around, true);
    QHBoxLayout *autoLyt = new QHBoxLayout(autoOpenFrame);
    autoLyt->setContentsMargins(16, 0, 16, 0);
    QLabel *autoOpenLabel = new QLabel(tr("Automatically turn on"), autoOpenFrame);
    mOpenTimeHCombox = new QComboBox(autoOpenFrame);
    mOpenTimeHCombox->setFixedWidth(64);
    mOpenTimeMCombox = new QComboBox(autoOpenFrame);
    mOpenTimeMCombox->setFixedWidth(64);
    mCloseTimeHCombox = new QComboBox(autoOpenFrame);
    mCloseTimeHCombox->setFixedWidth(64);
    mCloseTimeMCombox = new QComboBox(autoOpenFrame);
    mCloseTimeMCombox->setFixedWidth(64);
    for (int i = 0; i < 24; i++) {
        mOpenTimeHCombox->addItem(QStringLiteral("%1").arg(i, 2, 10, QLatin1Char('0')));
        mCloseTimeHCombox->addItem(QStringLiteral("%1").arg(i, 2, 10, QLatin1Char('0')));
    }
    for (int i = 0; i < 60; i++) {
        mOpenTimeMCombox->addItem(QStringLiteral("%1").arg(i, 2, 10, QLatin1Char('0')));
        mCloseTimeMCombox->addItem(QStringLiteral("%1").arg(i, 2, 10, QLatin1Char('0')));
    }
    QLabel * label_1 = new QLabel(autoOpenFrame);
    label_1->setFixedWidth(20);
    label_1->setText(tr("to"));
    QLabel *label_2 = new QLabel(autoOpenFrame);
    label_2->setFixedWidth(4);
    label_2->setText(":");
    QLabel *label_3 = new QLabel(autoOpenFrame);
    label_3->setFixedWidth(4);
    label_3->setText(":");
    mAutoOpenSwitchBtn = new KSwitchButton(autoOpenFrame);
    autoLyt->addWidget(autoOpenLabel);
    autoLyt->addStretch();
    autoLyt->addWidget(mOpenTimeHCombox);
    autoLyt->addWidget(label_2);
    autoLyt->addWidget(mOpenTimeMCombox);
    autoLyt->addWidget(label_1);
    autoLyt->addWidget(mCloseTimeHCombox);
    autoLyt->addWidget(label_3);
    autoLyt->addWidget(mCloseTimeMCombox);
    autoLyt->addSpacing(24);
    autoLyt->addWidget(mAutoOpenSwitchBtn);

    mMultiScreenWidget = new SwitchWidget(tr("Automatically turn on when multiple screens are connected"));
    mFullScreenWidget = new SwitchWidget(tr("Automatically open in full screen mode"));
    mAllowAlarmrWidget = new SwitchWidget(tr("Allow automatic alarm reminders in Do Not Disturb mode"));

    widget->addWidget(autoOpenFrame);
    widget->addWidget(mMultiScreenWidget);
    widget->addWidget(mFullScreenWidget);
    widget->addWidget(mAllowAlarmrWidget);
}

void NoticeUi::initSearchText()
{
    //~ contents_path /Notice/Notice Settings
    //~ contents_path /Notice/Get notifications from the app
    //~ contents_path /Notice/NotFaze Mode
}
