/* valainterface.c generated by valac, the Vala compiler
 * generated from valainterface.vala, do not modify */

/* valainterface.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))

struct _ValaInterfacePrivate {
	ValaList* prerequisites;
	ValaList* virtuals;
};


static gpointer vala_interface_parent_class = NULL;

#define VALA_INTERFACE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTERFACE, ValaInterfacePrivate))
static void vala_interface_real_add_method (ValaSymbol* base,
                                     ValaMethod* m);
static void vala_interface_real_add_property (ValaSymbol* base,
                                       ValaProperty* prop);
static ValaList* vala_interface_real_get_virtuals (ValaInterface* self);
static void vala_interface_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor);
static void vala_interface_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor);
static gboolean vala_interface_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                            ValaTypeSymbol* t);
static void vala_interface_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type);
static gboolean vala_interface_real_check (ValaCodeNode* base,
                                    ValaCodeContext* context);
static void vala_interface_finalize (ValaCodeNode * obj);


/**
 * Creates a new interface.
 *
 * @param name              type name
 * @param source_reference  reference to source code
 * @return                  newly created interface
 */
ValaInterface*
vala_interface_construct (GType object_type,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	ValaInterface* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaInterface*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaInterface*
vala_interface_new (const gchar* name,
                    ValaSourceReference* source_reference,
                    ValaComment* comment)
{
	return vala_interface_construct (VALA_TYPE_INTERFACE, name, source_reference, comment);
}


/**
 * Adds the specified interface or class to the list of prerequisites of
 * this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_add_prerequisite (ValaInterface* self,
                                 ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Prepends the specified interface or class to the list of
 * prerequisites of this interface.
 *
 * @param type an interface or class reference
 */
void
vala_interface_prepend_prerequisite (ValaInterface* self,
                                     ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->prerequisites;
	vala_list_insert (_tmp0_, 0, type);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_interface_get_prerequisites (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->prerequisites;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified method as a member to this interface.
 *
 * @param m a method
 */
static void
vala_interface_real_add_method (ValaSymbol* base,
                                ValaMethod* m)
{
	ValaInterface * self;
	ValaMemberBinding _tmp2_;
	ValaMemberBinding _tmp3_;
	gboolean _tmp16_ = FALSE;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	self = (ValaInterface*) base;
	g_return_if_fail (m != NULL);
	if (VALA_IS_CREATION_METHOD (m)) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
		_tmp1_ = _tmp0_;
		vala_report_error (_tmp1_, "construction methods may only be declared within classes and structs");
		vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		return;
	}
	_tmp2_ = vala_method_get_binding (m);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaObjectType* _tmp4_;
		ValaObjectType* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaScope* _tmp8_;
		ValaScope* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		ValaParameter* _tmp14_;
		ValaParameter* _tmp15_;
		_tmp4_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		vala_method_set_this_parameter (m, _tmp7_);
		_vala_code_node_unref0 (_tmp7_);
		_vala_code_node_unref0 (_tmp5_);
		_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_method_get_this_parameter (m);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_method_get_this_parameter (m);
		_tmp15_ = _tmp14_;
		vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
	}
	_tmp17_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp18_ = _tmp17_;
	if (!VALA_IS_VOID_TYPE (_tmp18_)) {
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp19_ = vala_method_get_postconditions (m);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp16_ = _tmp22_ > 0;
		_vala_iterable_unref0 (_tmp20_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		ValaDataType* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		ValaDataType* _tmp26_;
		ValaSourceReference* _tmp27_;
		ValaSourceReference* _tmp28_;
		ValaLocalVariable* _tmp29_;
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaLocalVariable* _tmp32_;
		_tmp23_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_data_type_copy (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp28_ = _tmp27_;
		_tmp29_ = vala_local_variable_new (_tmp26_, "result", NULL, _tmp28_);
		_tmp30_ = _tmp29_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp30_);
		_vala_code_node_unref0 (_tmp30_);
		_vala_code_node_unref0 (_tmp26_);
		_tmp31_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp32_ = _tmp31_;
		vala_local_variable_set_is_result (_tmp32_, TRUE);
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
}


/**
 * Adds the specified property as a member to this interface.
 *
 * @param prop a property
 */
static void
vala_interface_real_add_property (ValaSymbol* base,
                                  ValaProperty* prop)
{
	ValaInterface * self;
	ValaField* _tmp0_;
	ValaField* _tmp1_;
	ValaObjectType* _tmp4_;
	ValaObjectType* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	ValaScope* _tmp8_;
	ValaScope* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaParameter* _tmp14_;
	ValaParameter* _tmp15_;
	self = (ValaInterface*) base;
	g_return_if_fail (prop != NULL);
	_tmp0_ = vala_property_get_field (prop);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) prop);
		_tmp3_ = _tmp2_;
		vala_report_error (_tmp3_, "interface properties should be `abstract' or have `get' accessor and/o" \
"r `set' mutator");
		vala_code_node_set_error ((ValaCodeNode*) prop, TRUE);
		return;
	}
	VALA_SYMBOL_CLASS (vala_interface_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp4_ = vala_object_type_new ((ValaObjectTypeSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_parameter_new ("this", (ValaDataType*) _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	vala_property_set_this_parameter (prop, _tmp7_);
	_vala_code_node_unref0 (_tmp7_);
	_vala_code_node_unref0 (_tmp5_);
	_tmp8_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_property_get_this_parameter (prop);
	_tmp15_ = _tmp14_;
	vala_scope_add (_tmp9_, _tmp13_, (ValaSymbol*) _tmp15_);
}


static ValaList*
vala_interface_real_get_virtuals (ValaInterface* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	_tmp0_ = self->priv->virtuals;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


ValaList*
vala_interface_get_virtuals (ValaInterface* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALA_INTERFACE_GET_CLASS (self)->get_virtuals (self);
}


static void
vala_interface_real_accept (ValaCodeNode* base,
                            ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_interface (visitor, self);
}


static void
vala_interface_real_accept_children (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp34_;
		gint _m_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _m_index = 0;
		_tmp34_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp34_;
		_tmp35_ = _m_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_m_size = _tmp37_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaMethod* m = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaMethod* _tmp44_;
			_tmp38_ = _m_index;
			_m_index = _tmp38_ + 1;
			_tmp39_ = _m_index;
			_tmp40_ = _m_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _m_list;
			_tmp42_ = _m_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			m = (ValaMethod*) _tmp43_;
			_tmp44_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp45_;
		gint _f_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _f_index = 0;
		_tmp45_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp45_;
		_tmp46_ = _f_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_f_size = _tmp48_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaField* f = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaField* _tmp55_;
			_tmp49_ = _f_index;
			_f_index = _tmp49_ + 1;
			_tmp50_ = _f_index;
			_tmp51_ = _f_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _f_list;
			_tmp53_ = _f_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			f = (ValaField*) _tmp54_;
			_tmp55_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp56_;
		gint _c_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _c_index = 0;
		_tmp56_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp56_;
		_tmp57_ = _c_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_c_size = _tmp59_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaConstant* c = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaConstant* _tmp66_;
			_tmp60_ = _c_index;
			_c_index = _tmp60_ + 1;
			_tmp61_ = _c_index;
			_tmp62_ = _c_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _c_list;
			_tmp64_ = _c_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			c = (ValaConstant*) _tmp65_;
			_tmp66_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp89_;
		gint _cl_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _cl_index = 0;
		_tmp89_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp89_;
		_tmp90_ = _cl_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_cl_size = _tmp92_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			ValaClass* cl = NULL;
			ValaList* _tmp96_;
			gint _tmp97_;
			gpointer _tmp98_;
			ValaClass* _tmp99_;
			_tmp93_ = _cl_index;
			_cl_index = _tmp93_ + 1;
			_tmp94_ = _cl_index;
			_tmp95_ = _cl_size;
			if (!(_tmp94_ < _tmp95_)) {
				break;
			}
			_tmp96_ = _cl_list;
			_tmp97_ = _cl_index;
			_tmp98_ = vala_list_get (_tmp96_, _tmp97_);
			cl = (ValaClass*) _tmp98_;
			_tmp99_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp99_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp100_;
		gint _st_size = 0;
		ValaList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _st_index = 0;
		_tmp100_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp100_;
		_tmp101_ = _st_list;
		_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_st_size = _tmp103_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			ValaStruct* st = NULL;
			ValaList* _tmp107_;
			gint _tmp108_;
			gpointer _tmp109_;
			ValaStruct* _tmp110_;
			_tmp104_ = _st_index;
			_st_index = _tmp104_ + 1;
			_tmp105_ = _st_index;
			_tmp106_ = _st_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _st_list;
			_tmp108_ = _st_index;
			_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
			st = (ValaStruct*) _tmp109_;
			_tmp110_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp110_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp111_;
		gint _d_size = 0;
		ValaList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _d_index = 0;
		_tmp111_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp111_;
		_tmp112_ = _d_list;
		_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_d_size = _tmp114_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			ValaDelegate* d = NULL;
			ValaList* _tmp118_;
			gint _tmp119_;
			gpointer _tmp120_;
			ValaDelegate* _tmp121_;
			_tmp115_ = _d_index;
			_d_index = _tmp115_ + 1;
			_tmp116_ = _d_index;
			_tmp117_ = _d_size;
			if (!(_tmp116_ < _tmp117_)) {
				break;
			}
			_tmp118_ = _d_list;
			_tmp119_ = _d_index;
			_tmp120_ = vala_list_get (_tmp118_, _tmp119_);
			d = (ValaDelegate*) _tmp120_;
			_tmp121_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp121_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_interface_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	result = TRUE;
	return result;
}


static gboolean
vala_interface_real_is_subtype_of (ValaTypeSymbol* base,
                                   ValaTypeSymbol* t)
{
	ValaInterface * self;
	gboolean result = FALSE;
	self = (ValaInterface*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _prerequisite_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _prerequisite_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _prerequisite_index = 0;
		_tmp0_ = self->priv->prerequisites;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_prerequisite_list = _tmp1_;
		_tmp2_ = _prerequisite_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_prerequisite_size = _tmp4_;
		_prerequisite_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* prerequisite = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _prerequisite_index;
			_prerequisite_index = _tmp5_ + 1;
			_tmp6_ = _prerequisite_index;
			_tmp7_ = _prerequisite_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _prerequisite_list;
			_tmp9_ = _prerequisite_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			prerequisite = (ValaDataType*) _tmp10_;
			_tmp12_ = prerequisite;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = prerequisite;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (prerequisite);
				_vala_iterable_unref0 (_prerequisite_list);
				return result;
			}
			_vala_code_node_unref0 (prerequisite);
		}
		_vala_iterable_unref0 (_prerequisite_list);
	}
	result = FALSE;
	return result;
}


static void
vala_interface_real_replace_type (ValaCodeNode* base,
                                  ValaDataType* old_type,
                                  ValaDataType* new_type)
{
	ValaInterface * self;
	self = (ValaInterface*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->prerequisites;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->prerequisites;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->prerequisites;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_interface_real_check (ValaCodeNode* base,
                           ValaCodeContext* context)
{
	ValaInterface * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaClass* prereq_class = NULL;
	gboolean _tmp144_;
	gboolean _tmp145_;
	ValaMap* positions = NULL;
	GHashFunc _tmp280_;
	GEqualFunc _tmp281_;
	GEqualFunc _tmp282_;
	ValaHashMap* _tmp283_;
	gboolean ordered_seen = FALSE;
	gboolean unordered_seen = FALSE;
	gboolean _tmp360_;
	ValaSemanticAnalyzer* _tmp383_;
	ValaSemanticAnalyzer* _tmp384_;
	ValaSourceFile* _tmp385_;
	ValaSemanticAnalyzer* _tmp386_;
	ValaSemanticAnalyzer* _tmp387_;
	ValaSymbol* _tmp388_;
	gboolean _tmp389_;
	gboolean _tmp390_;
	self = (ValaInterface*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _prerequisite_reference_list = NULL;
		ValaList* _tmp24_;
		gint _prerequisite_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _prerequisite_reference_index = 0;
		_tmp24_ = vala_interface_get_prerequisites (self);
		_prerequisite_reference_list = _tmp24_;
		_tmp25_ = _prerequisite_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_prerequisite_reference_size = _tmp27_;
		_prerequisite_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* prerequisite_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaSemanticAnalyzer* _tmp34_;
			ValaSemanticAnalyzer* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp28_ = _prerequisite_reference_index;
			_prerequisite_reference_index = _tmp28_ + 1;
			_tmp29_ = _prerequisite_reference_index;
			_tmp30_ = _prerequisite_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _prerequisite_reference_list;
			_tmp32_ = _prerequisite_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			prerequisite_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = vala_code_context_get_analyzer (context);
			_tmp35_ = _tmp34_;
			_tmp36_ = prerequisite_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp35_, (ValaSymbol*) self, _tmp36_)) {
				ValaSourceReference* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaDataType* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp38_ = _tmp37_;
				_tmp39_ = prerequisite_reference;
				_tmp40_ = vala_code_node_to_string ((ValaCodeNode*) _tmp39_);
				_tmp41_ = _tmp40_;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("prerequisite `%s` is less accessible than interface `%s`", _tmp41_, _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp38_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				result = FALSE;
				_vala_code_node_unref0 (prerequisite_reference);
				_vala_iterable_unref0 (_prerequisite_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (prerequisite_reference);
		}
		_vala_iterable_unref0 (_prerequisite_reference_list);
	}
	prereq_class = NULL;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp46_;
		gint _prereq_size = 0;
		ValaList* _tmp47_;
		gint _tmp48_;
		gint _tmp49_;
		gint _prereq_index = 0;
		_tmp46_ = vala_interface_get_prerequisites (self);
		_prereq_list = _tmp46_;
		_tmp47_ = _prereq_list;
		_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
		_tmp49_ = _tmp48_;
		_prereq_size = _tmp49_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp53_;
			gint _tmp54_;
			gpointer _tmp55_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp66_;
			ValaTypeSymbol* _tmp67_;
			ValaTypeSymbol* _tmp68_;
			_tmp50_ = _prereq_index;
			_prereq_index = _tmp50_ + 1;
			_tmp51_ = _prereq_index;
			_tmp52_ = _prereq_size;
			if (!(_tmp51_ < _tmp52_)) {
				break;
			}
			_tmp53_ = _prereq_list;
			_tmp54_ = _prereq_index;
			_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
			prereq = (ValaDataType*) _tmp55_;
			_tmp56_ = prereq;
			if (!VALA_IS_OBJECT_TYPE (_tmp56_)) {
				ValaSourceReference* _tmp57_;
				ValaSourceReference* _tmp58_;
				ValaDataType* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp57_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp58_ = _tmp57_;
				_tmp59_ = prereq;
				_tmp60_ = vala_code_node_to_string ((ValaCodeNode*) _tmp59_);
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp63_ = _tmp62_;
				_tmp64_ = g_strdup_printf ("Prerequisite `%s' of interface `%s' is not a class or interface", _tmp61_, _tmp63_);
				_tmp65_ = _tmp64_;
				vala_report_error (_tmp58_, _tmp65_);
				_g_free0 (_tmp65_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp61_);
				result = FALSE;
				_vala_code_node_unref0 (prereq);
				_vala_iterable_unref0 (_prereq_list);
				_vala_code_node_unref0 (prereq_class);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp66_ = prereq;
			_tmp67_ = vala_data_type_get_data_type (_tmp66_);
			_tmp68_ = _tmp67_;
			if (VALA_IS_CLASS (_tmp68_)) {
				ValaClass* _tmp69_;
				ValaDataType* _tmp84_;
				ValaTypeSymbol* _tmp85_;
				ValaTypeSymbol* _tmp86_;
				ValaClass* _tmp87_;
				_tmp69_ = prereq_class;
				if (_tmp69_ != NULL) {
					ValaSourceReference* _tmp70_;
					ValaSourceReference* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					ValaDataType* _tmp74_;
					ValaTypeSymbol* _tmp75_;
					ValaTypeSymbol* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					ValaClass* _tmp79_;
					gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					gchar* _tmp83_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp71_ = _tmp70_;
					_tmp72_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp73_ = _tmp72_;
					_tmp74_ = prereq;
					_tmp75_ = vala_data_type_get_data_type (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp76_);
					_tmp78_ = _tmp77_;
					_tmp79_ = prereq_class;
					_tmp80_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp79_);
					_tmp81_ = _tmp80_;
					_tmp82_ = g_strdup_printf ("%s: Interfaces cannot have multiple instantiable prerequisites (`%s' a" \
"nd `%s')", _tmp73_, _tmp78_, _tmp81_);
					_tmp83_ = _tmp82_;
					vala_report_error (_tmp71_, _tmp83_);
					_g_free0 (_tmp83_);
					_g_free0 (_tmp81_);
					_g_free0 (_tmp78_);
					_g_free0 (_tmp73_);
					result = FALSE;
					_vala_code_node_unref0 (prereq);
					_vala_iterable_unref0 (_prereq_list);
					_vala_code_node_unref0 (prereq_class);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_tmp84_ = prereq;
				_tmp85_ = vala_data_type_get_data_type (_tmp84_);
				_tmp86_ = _tmp85_;
				_tmp87_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CLASS, ValaClass));
				_vala_code_node_unref0 (prereq_class);
				prereq_class = _tmp87_;
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp88_;
		ValaList* _tmp89_;
		gint _type_size = 0;
		ValaList* _tmp90_;
		gint _tmp91_;
		gint _tmp92_;
		gint _type_index = 0;
		_tmp88_ = self->priv->prerequisites;
		_tmp89_ = _vala_iterable_ref0 (_tmp88_);
		_type_list = _tmp89_;
		_tmp90_ = _type_list;
		_tmp91_ = vala_collection_get_size ((ValaCollection*) _tmp90_);
		_tmp92_ = _tmp91_;
		_type_size = _tmp92_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			ValaDataType* type = NULL;
			ValaList* _tmp96_;
			gint _tmp97_;
			gpointer _tmp98_;
			ValaDataType* _tmp99_;
			_tmp93_ = _type_index;
			_type_index = _tmp93_ + 1;
			_tmp94_ = _type_index;
			_tmp95_ = _type_size;
			if (!(_tmp94_ < _tmp95_)) {
				break;
			}
			_tmp96_ = _type_list;
			_tmp97_ = _type_index;
			_tmp98_ = vala_list_get (_tmp96_, _tmp97_);
			type = (ValaDataType*) _tmp98_;
			_tmp99_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp99_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp100_;
		gint _p_size = 0;
		ValaList* _tmp101_;
		gint _tmp102_;
		gint _tmp103_;
		gint _p_index = 0;
		_tmp100_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp100_;
		_tmp101_ = _p_list;
		_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
		_tmp103_ = _tmp102_;
		_p_size = _tmp103_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp104_;
			gint _tmp105_;
			gint _tmp106_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp107_;
			gint _tmp108_;
			gpointer _tmp109_;
			ValaTypeParameter* _tmp110_;
			_tmp104_ = _p_index;
			_p_index = _tmp104_ + 1;
			_tmp105_ = _p_index;
			_tmp106_ = _p_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _p_list;
			_tmp108_ = _p_index;
			_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
			p = (ValaTypeParameter*) _tmp109_;
			_tmp110_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp110_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp111_;
		gint _en_size = 0;
		ValaList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _en_index = 0;
		_tmp111_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp111_;
		_tmp112_ = _en_list;
		_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_en_size = _tmp114_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			gint _tmp117_;
			ValaEnum* en = NULL;
			ValaList* _tmp118_;
			gint _tmp119_;
			gpointer _tmp120_;
			ValaEnum* _tmp121_;
			_tmp115_ = _en_index;
			_en_index = _tmp115_ + 1;
			_tmp116_ = _en_index;
			_tmp117_ = _en_size;
			if (!(_tmp116_ < _tmp117_)) {
				break;
			}
			_tmp118_ = _en_list;
			_tmp119_ = _en_index;
			_tmp120_ = vala_list_get (_tmp118_, _tmp119_);
			en = (ValaEnum*) _tmp120_;
			_tmp121_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp121_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp122_;
		gint _f_size = 0;
		ValaList* _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		gint _f_index = 0;
		_tmp122_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp122_;
		_tmp123_ = _f_list;
		_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
		_tmp125_ = _tmp124_;
		_f_size = _tmp125_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp126_;
			gint _tmp127_;
			gint _tmp128_;
			ValaField* f = NULL;
			ValaList* _tmp129_;
			gint _tmp130_;
			gpointer _tmp131_;
			ValaField* _tmp132_;
			_tmp126_ = _f_index;
			_f_index = _tmp126_ + 1;
			_tmp127_ = _f_index;
			_tmp128_ = _f_size;
			if (!(_tmp127_ < _tmp128_)) {
				break;
			}
			_tmp129_ = _f_list;
			_tmp130_ = _f_index;
			_tmp131_ = vala_list_get (_tmp129_, _tmp130_);
			f = (ValaField*) _tmp131_;
			_tmp132_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp132_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp133_;
		gint _c_size = 0;
		ValaList* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gint _c_index = 0;
		_tmp133_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp133_;
		_tmp134_ = _c_list;
		_tmp135_ = vala_collection_get_size ((ValaCollection*) _tmp134_);
		_tmp136_ = _tmp135_;
		_c_size = _tmp136_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp137_;
			gint _tmp138_;
			gint _tmp139_;
			ValaConstant* c = NULL;
			ValaList* _tmp140_;
			gint _tmp141_;
			gpointer _tmp142_;
			ValaConstant* _tmp143_;
			_tmp137_ = _c_index;
			_c_index = _tmp137_ + 1;
			_tmp138_ = _c_index;
			_tmp139_ = _c_size;
			if (!(_tmp138_ < _tmp139_)) {
				break;
			}
			_tmp140_ = _c_list;
			_tmp141_ = _c_index;
			_tmp142_ = vala_list_get (_tmp140_, _tmp141_);
			c = (ValaConstant*) _tmp142_;
			_tmp143_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp143_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	_tmp144_ = vala_code_context_get_abi_stability (context);
	_tmp145_ = _tmp144_;
	if (_tmp145_) {
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp146_;
			gint _s_size = 0;
			ValaList* _tmp147_;
			gint _tmp148_;
			gint _tmp149_;
			gint _s_index = 0;
			_tmp146_ = vala_object_type_symbol_get_members ((ValaObjectTypeSymbol*) self);
			_s_list = _tmp146_;
			_tmp147_ = _s_list;
			_tmp148_ = vala_collection_get_size ((ValaCollection*) _tmp147_);
			_tmp149_ = _tmp148_;
			_s_size = _tmp149_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp150_;
				gint _tmp151_;
				gint _tmp152_;
				ValaSymbol* s = NULL;
				ValaList* _tmp153_;
				gint _tmp154_;
				gpointer _tmp155_;
				ValaSymbol* _tmp156_;
				_tmp150_ = _s_index;
				_s_index = _tmp150_ + 1;
				_tmp151_ = _s_index;
				_tmp152_ = _s_size;
				if (!(_tmp151_ < _tmp152_)) {
					break;
				}
				_tmp153_ = _s_list;
				_tmp154_ = _s_index;
				_tmp155_ = vala_list_get (_tmp153_, _tmp154_);
				s = (ValaSymbol*) _tmp155_;
				_tmp156_ = s;
				if (VALA_IS_METHOD (_tmp156_)) {
					ValaMethod* m = NULL;
					ValaSymbol* _tmp157_;
					ValaMethod* _tmp158_;
					ValaMethod* _tmp159_;
					gboolean _tmp160_ = FALSE;
					ValaMethod* _tmp161_;
					gboolean _tmp162_;
					gboolean _tmp163_;
					_tmp157_ = s;
					_tmp158_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp157_, VALA_TYPE_METHOD, ValaMethod));
					m = _tmp158_;
					_tmp159_ = m;
					vala_code_node_check ((ValaCodeNode*) _tmp159_, context);
					_tmp161_ = m;
					_tmp162_ = vala_method_get_is_virtual (_tmp161_);
					_tmp163_ = _tmp162_;
					if (_tmp163_) {
						_tmp160_ = TRUE;
					} else {
						ValaMethod* _tmp164_;
						gboolean _tmp165_;
						gboolean _tmp166_;
						_tmp164_ = m;
						_tmp165_ = vala_method_get_is_abstract (_tmp164_);
						_tmp166_ = _tmp165_;
						_tmp160_ = _tmp166_;
					}
					if (_tmp160_) {
						ValaList* _tmp167_;
						ValaMethod* _tmp168_;
						_tmp167_ = self->priv->virtuals;
						_tmp168_ = m;
						vala_collection_add ((ValaCollection*) _tmp167_, (ValaSymbol*) _tmp168_);
					}
					_vala_code_node_unref0 (m);
				} else {
					ValaSymbol* _tmp169_;
					_tmp169_ = s;
					if (VALA_IS_SIGNAL (_tmp169_)) {
						ValaSignal* sig = NULL;
						ValaSymbol* _tmp170_;
						ValaSignal* _tmp171_;
						ValaSignal* _tmp172_;
						ValaSignal* _tmp173_;
						gboolean _tmp174_;
						gboolean _tmp175_;
						_tmp170_ = s;
						_tmp171_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp170_, VALA_TYPE_SIGNAL, ValaSignal));
						sig = _tmp171_;
						_tmp172_ = sig;
						vala_code_node_check ((ValaCodeNode*) _tmp172_, context);
						_tmp173_ = sig;
						_tmp174_ = vala_signal_get_is_virtual (_tmp173_);
						_tmp175_ = _tmp174_;
						if (_tmp175_) {
							ValaList* _tmp176_;
							ValaSignal* _tmp177_;
							_tmp176_ = self->priv->virtuals;
							_tmp177_ = sig;
							vala_collection_add ((ValaCollection*) _tmp176_, (ValaSymbol*) _tmp177_);
						}
						_vala_code_node_unref0 (sig);
					} else {
						ValaSymbol* _tmp178_;
						_tmp178_ = s;
						if (VALA_IS_PROPERTY (_tmp178_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp179_;
							ValaProperty* _tmp180_;
							ValaProperty* _tmp181_;
							gboolean _tmp182_ = FALSE;
							ValaProperty* _tmp183_;
							gboolean _tmp184_;
							gboolean _tmp185_;
							_tmp179_ = s;
							_tmp180_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp179_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp180_;
							_tmp181_ = prop;
							vala_code_node_check ((ValaCodeNode*) _tmp181_, context);
							_tmp183_ = prop;
							_tmp184_ = vala_property_get_is_virtual (_tmp183_);
							_tmp185_ = _tmp184_;
							if (_tmp185_) {
								_tmp182_ = TRUE;
							} else {
								ValaProperty* _tmp186_;
								gboolean _tmp187_;
								gboolean _tmp188_;
								_tmp186_ = prop;
								_tmp187_ = vala_property_get_is_abstract (_tmp186_);
								_tmp188_ = _tmp187_;
								_tmp182_ = _tmp188_;
							}
							if (_tmp182_) {
								ValaList* _tmp189_;
								ValaProperty* _tmp190_;
								_tmp189_ = self->priv->virtuals;
								_tmp190_ = prop;
								vala_collection_add ((ValaCollection*) _tmp189_, (ValaSymbol*) _tmp190_);
							}
							_vala_code_node_unref0 (prop);
						}
					}
				}
				_vala_code_node_unref0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
	} else {
		{
			ValaList* _m_list = NULL;
			ValaList* _tmp191_;
			gint _m_size = 0;
			ValaList* _tmp192_;
			gint _tmp193_;
			gint _tmp194_;
			gint _m_index = 0;
			_tmp191_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
			_m_list = _tmp191_;
			_tmp192_ = _m_list;
			_tmp193_ = vala_collection_get_size ((ValaCollection*) _tmp192_);
			_tmp194_ = _tmp193_;
			_m_size = _tmp194_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp195_;
				gint _tmp196_;
				gint _tmp197_;
				ValaMethod* m = NULL;
				ValaList* _tmp198_;
				gint _tmp199_;
				gpointer _tmp200_;
				ValaMethod* _tmp201_;
				gboolean _tmp202_ = FALSE;
				ValaMethod* _tmp203_;
				gboolean _tmp204_;
				gboolean _tmp205_;
				_tmp195_ = _m_index;
				_m_index = _tmp195_ + 1;
				_tmp196_ = _m_index;
				_tmp197_ = _m_size;
				if (!(_tmp196_ < _tmp197_)) {
					break;
				}
				_tmp198_ = _m_list;
				_tmp199_ = _m_index;
				_tmp200_ = vala_list_get (_tmp198_, _tmp199_);
				m = (ValaMethod*) _tmp200_;
				_tmp201_ = m;
				vala_code_node_check ((ValaCodeNode*) _tmp201_, context);
				_tmp203_ = m;
				_tmp204_ = vala_method_get_is_virtual (_tmp203_);
				_tmp205_ = _tmp204_;
				if (_tmp205_) {
					_tmp202_ = TRUE;
				} else {
					ValaMethod* _tmp206_;
					gboolean _tmp207_;
					gboolean _tmp208_;
					_tmp206_ = m;
					_tmp207_ = vala_method_get_is_abstract (_tmp206_);
					_tmp208_ = _tmp207_;
					_tmp202_ = _tmp208_;
				}
				if (_tmp202_) {
					ValaList* _tmp209_;
					ValaMethod* _tmp210_;
					_tmp209_ = self->priv->virtuals;
					_tmp210_ = m;
					vala_collection_add ((ValaCollection*) _tmp209_, (ValaSymbol*) _tmp210_);
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		{
			ValaList* _sig_list = NULL;
			ValaList* _tmp211_;
			gint _sig_size = 0;
			ValaList* _tmp212_;
			gint _tmp213_;
			gint _tmp214_;
			gint _sig_index = 0;
			_tmp211_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
			_sig_list = _tmp211_;
			_tmp212_ = _sig_list;
			_tmp213_ = vala_collection_get_size ((ValaCollection*) _tmp212_);
			_tmp214_ = _tmp213_;
			_sig_size = _tmp214_;
			_sig_index = -1;
			while (TRUE) {
				gint _tmp215_;
				gint _tmp216_;
				gint _tmp217_;
				ValaSignal* sig = NULL;
				ValaList* _tmp218_;
				gint _tmp219_;
				gpointer _tmp220_;
				ValaSignal* _tmp221_;
				ValaSignal* _tmp222_;
				gboolean _tmp223_;
				gboolean _tmp224_;
				_tmp215_ = _sig_index;
				_sig_index = _tmp215_ + 1;
				_tmp216_ = _sig_index;
				_tmp217_ = _sig_size;
				if (!(_tmp216_ < _tmp217_)) {
					break;
				}
				_tmp218_ = _sig_list;
				_tmp219_ = _sig_index;
				_tmp220_ = vala_list_get (_tmp218_, _tmp219_);
				sig = (ValaSignal*) _tmp220_;
				_tmp221_ = sig;
				vala_code_node_check ((ValaCodeNode*) _tmp221_, context);
				_tmp222_ = sig;
				_tmp223_ = vala_signal_get_is_virtual (_tmp222_);
				_tmp224_ = _tmp223_;
				if (_tmp224_) {
					ValaList* _tmp225_;
					ValaSignal* _tmp226_;
					_tmp225_ = self->priv->virtuals;
					_tmp226_ = sig;
					vala_collection_add ((ValaCollection*) _tmp225_, (ValaSymbol*) _tmp226_);
				}
				_vala_code_node_unref0 (sig);
			}
			_vala_iterable_unref0 (_sig_list);
		}
		{
			ValaList* _prop_list = NULL;
			ValaList* _tmp227_;
			gint _prop_size = 0;
			ValaList* _tmp228_;
			gint _tmp229_;
			gint _tmp230_;
			gint _prop_index = 0;
			_tmp227_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
			_prop_list = _tmp227_;
			_tmp228_ = _prop_list;
			_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
			_tmp230_ = _tmp229_;
			_prop_size = _tmp230_;
			_prop_index = -1;
			while (TRUE) {
				gint _tmp231_;
				gint _tmp232_;
				gint _tmp233_;
				ValaProperty* prop = NULL;
				ValaList* _tmp234_;
				gint _tmp235_;
				gpointer _tmp236_;
				ValaProperty* _tmp237_;
				gboolean _tmp238_ = FALSE;
				ValaProperty* _tmp239_;
				gboolean _tmp240_;
				gboolean _tmp241_;
				_tmp231_ = _prop_index;
				_prop_index = _tmp231_ + 1;
				_tmp232_ = _prop_index;
				_tmp233_ = _prop_size;
				if (!(_tmp232_ < _tmp233_)) {
					break;
				}
				_tmp234_ = _prop_list;
				_tmp235_ = _prop_index;
				_tmp236_ = vala_list_get (_tmp234_, _tmp235_);
				prop = (ValaProperty*) _tmp236_;
				_tmp237_ = prop;
				vala_code_node_check ((ValaCodeNode*) _tmp237_, context);
				_tmp239_ = prop;
				_tmp240_ = vala_property_get_is_virtual (_tmp239_);
				_tmp241_ = _tmp240_;
				if (_tmp241_) {
					_tmp238_ = TRUE;
				} else {
					ValaProperty* _tmp242_;
					gboolean _tmp243_;
					gboolean _tmp244_;
					_tmp242_ = prop;
					_tmp243_ = vala_property_get_is_abstract (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp238_ = _tmp244_;
				}
				if (_tmp238_) {
					ValaList* _tmp245_;
					ValaProperty* _tmp246_;
					_tmp245_ = self->priv->virtuals;
					_tmp246_ = prop;
					vala_collection_add ((ValaCollection*) _tmp245_, (ValaSymbol*) _tmp246_);
				}
				_vala_code_node_unref0 (prop);
			}
			_vala_iterable_unref0 (_prop_list);
		}
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp247_;
		gint _cl_size = 0;
		ValaList* _tmp248_;
		gint _tmp249_;
		gint _tmp250_;
		gint _cl_index = 0;
		_tmp247_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp247_;
		_tmp248_ = _cl_list;
		_tmp249_ = vala_collection_get_size ((ValaCollection*) _tmp248_);
		_tmp250_ = _tmp249_;
		_cl_size = _tmp250_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp251_;
			gint _tmp252_;
			gint _tmp253_;
			ValaClass* cl = NULL;
			ValaList* _tmp254_;
			gint _tmp255_;
			gpointer _tmp256_;
			ValaClass* _tmp257_;
			_tmp251_ = _cl_index;
			_cl_index = _tmp251_ + 1;
			_tmp252_ = _cl_index;
			_tmp253_ = _cl_size;
			if (!(_tmp252_ < _tmp253_)) {
				break;
			}
			_tmp254_ = _cl_list;
			_tmp255_ = _cl_index;
			_tmp256_ = vala_list_get (_tmp254_, _tmp255_);
			cl = (ValaClass*) _tmp256_;
			_tmp257_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp258_;
		gint _st_size = 0;
		ValaList* _tmp259_;
		gint _tmp260_;
		gint _tmp261_;
		gint _st_index = 0;
		_tmp258_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp258_;
		_tmp259_ = _st_list;
		_tmp260_ = vala_collection_get_size ((ValaCollection*) _tmp259_);
		_tmp261_ = _tmp260_;
		_st_size = _tmp261_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp262_;
			gint _tmp263_;
			gint _tmp264_;
			ValaStruct* st = NULL;
			ValaList* _tmp265_;
			gint _tmp266_;
			gpointer _tmp267_;
			ValaStruct* _tmp268_;
			_tmp262_ = _st_index;
			_st_index = _tmp262_ + 1;
			_tmp263_ = _st_index;
			_tmp264_ = _st_size;
			if (!(_tmp263_ < _tmp264_)) {
				break;
			}
			_tmp265_ = _st_list;
			_tmp266_ = _st_index;
			_tmp267_ = vala_list_get (_tmp265_, _tmp266_);
			st = (ValaStruct*) _tmp267_;
			_tmp268_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp268_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp269_;
		gint _d_size = 0;
		ValaList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		gint _d_index = 0;
		_tmp269_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp269_;
		_tmp270_ = _d_list;
		_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
		_tmp272_ = _tmp271_;
		_d_size = _tmp272_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp273_;
			gint _tmp274_;
			gint _tmp275_;
			ValaDelegate* d = NULL;
			ValaList* _tmp276_;
			gint _tmp277_;
			gpointer _tmp278_;
			ValaDelegate* _tmp279_;
			_tmp273_ = _d_index;
			_d_index = _tmp273_ + 1;
			_tmp274_ = _d_index;
			_tmp275_ = _d_size;
			if (!(_tmp274_ < _tmp275_)) {
				break;
			}
			_tmp276_ = _d_list;
			_tmp277_ = _d_index;
			_tmp278_ = vala_list_get (_tmp276_, _tmp277_);
			d = (ValaDelegate*) _tmp278_;
			_tmp279_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp279_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp280_ = g_direct_hash;
	_tmp281_ = g_direct_equal;
	_tmp282_ = g_direct_equal;
	_tmp283_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp280_, _tmp281_, _tmp282_);
	positions = (ValaMap*) _tmp283_;
	ordered_seen = FALSE;
	unordered_seen = FALSE;
	{
		ValaList* _sym_list = NULL;
		ValaList* _tmp284_;
		ValaList* _tmp285_;
		gint _sym_size = 0;
		ValaList* _tmp286_;
		gint _tmp287_;
		gint _tmp288_;
		gint _sym_index = 0;
		_tmp284_ = self->priv->virtuals;
		_tmp285_ = _vala_iterable_ref0 (_tmp284_);
		_sym_list = _tmp285_;
		_tmp286_ = _sym_list;
		_tmp287_ = vala_collection_get_size ((ValaCollection*) _tmp286_);
		_tmp288_ = _tmp287_;
		_sym_size = _tmp288_;
		_sym_index = -1;
		while (TRUE) {
			gint _tmp289_;
			gint _tmp290_;
			gint _tmp291_;
			ValaSymbol* sym = NULL;
			ValaList* _tmp292_;
			gint _tmp293_;
			gpointer _tmp294_;
			gint ordering = 0;
			ValaSymbol* _tmp295_;
			gint _tmp296_;
			gboolean ordered = FALSE;
			gint _tmp305_;
			gboolean _tmp306_ = FALSE;
			gboolean _tmp307_ = FALSE;
			gboolean _tmp308_;
			gboolean _tmp319_ = FALSE;
			gboolean _tmp320_;
			gboolean _tmp322_ = FALSE;
			gboolean _tmp323_ = FALSE;
			gboolean _tmp324_;
			gboolean _tmp335_ = FALSE;
			gboolean _tmp336_;
			gboolean _tmp338_ = FALSE;
			gboolean _tmp339_;
			_tmp289_ = _sym_index;
			_sym_index = _tmp289_ + 1;
			_tmp290_ = _sym_index;
			_tmp291_ = _sym_size;
			if (!(_tmp290_ < _tmp291_)) {
				break;
			}
			_tmp292_ = _sym_list;
			_tmp293_ = _sym_index;
			_tmp294_ = vala_list_get (_tmp292_, _tmp293_);
			sym = (ValaSymbol*) _tmp294_;
			_tmp295_ = sym;
			ordering = vala_code_node_get_attribute_integer ((ValaCodeNode*) _tmp295_, "CCode", "ordering", -1);
			_tmp296_ = ordering;
			if (_tmp296_ < -1) {
				ValaSymbol* _tmp297_;
				ValaSourceReference* _tmp298_;
				ValaSourceReference* _tmp299_;
				ValaSymbol* _tmp300_;
				gchar* _tmp301_;
				gchar* _tmp302_;
				gchar* _tmp303_;
				gchar* _tmp304_;
				_tmp297_ = sym;
				_tmp298_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp297_);
				_tmp299_ = _tmp298_;
				_tmp300_ = sym;
				_tmp301_ = vala_symbol_get_full_name (_tmp300_);
				_tmp302_ = _tmp301_;
				_tmp303_ = g_strdup_printf ("%s: Invalid ordering", _tmp302_);
				_tmp304_ = _tmp303_;
				vala_report_error (_tmp299_, _tmp304_);
				_g_free0 (_tmp304_);
				_g_free0 (_tmp302_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				ordered_seen = TRUE;
				unordered_seen = TRUE;
				_vala_code_node_unref0 (sym);
				continue;
			}
			_tmp305_ = ordering;
			ordered = _tmp305_ != -1;
			_tmp308_ = ordered;
			if (_tmp308_) {
				gboolean _tmp309_;
				_tmp309_ = unordered_seen;
				_tmp307_ = _tmp309_;
			} else {
				_tmp307_ = FALSE;
			}
			if (_tmp307_) {
				gboolean _tmp310_;
				_tmp310_ = ordered_seen;
				_tmp306_ = !_tmp310_;
			} else {
				_tmp306_ = FALSE;
			}
			if (_tmp306_) {
				ValaSymbol* _tmp311_;
				ValaSourceReference* _tmp312_;
				ValaSourceReference* _tmp313_;
				ValaSymbol* _tmp314_;
				gchar* _tmp315_;
				gchar* _tmp316_;
				gchar* _tmp317_;
				gchar* _tmp318_;
				_tmp311_ = sym;
				_tmp312_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp311_);
				_tmp313_ = _tmp312_;
				_tmp314_ = sym;
				_tmp315_ = vala_symbol_get_full_name (_tmp314_);
				_tmp316_ = _tmp315_;
				_tmp317_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp316_);
				_tmp318_ = _tmp317_;
				vala_report_error (_tmp313_, _tmp318_);
				_g_free0 (_tmp318_);
				_g_free0 (_tmp316_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp320_ = ordered_seen;
			if (_tmp320_) {
				_tmp319_ = TRUE;
			} else {
				gboolean _tmp321_;
				_tmp321_ = ordered;
				_tmp319_ = _tmp321_;
			}
			ordered_seen = _tmp319_;
			_tmp324_ = ordered;
			if (!_tmp324_) {
				gboolean _tmp325_;
				_tmp325_ = unordered_seen;
				_tmp323_ = !_tmp325_;
			} else {
				_tmp323_ = FALSE;
			}
			if (_tmp323_) {
				gboolean _tmp326_;
				_tmp326_ = ordered_seen;
				_tmp322_ = _tmp326_;
			} else {
				_tmp322_ = FALSE;
			}
			if (_tmp322_) {
				ValaSymbol* _tmp327_;
				ValaSourceReference* _tmp328_;
				ValaSourceReference* _tmp329_;
				ValaSymbol* _tmp330_;
				gchar* _tmp331_;
				gchar* _tmp332_;
				gchar* _tmp333_;
				gchar* _tmp334_;
				_tmp327_ = sym;
				_tmp328_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp327_);
				_tmp329_ = _tmp328_;
				_tmp330_ = sym;
				_tmp331_ = vala_symbol_get_full_name (_tmp330_);
				_tmp332_ = _tmp331_;
				_tmp333_ = g_strdup_printf ("%s: Cannot mix ordered and unordered virtuals", _tmp332_);
				_tmp334_ = _tmp333_;
				vala_report_error (_tmp329_, _tmp334_);
				_g_free0 (_tmp334_);
				_g_free0 (_tmp332_);
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp336_ = unordered_seen;
			if (_tmp336_) {
				_tmp335_ = TRUE;
			} else {
				gboolean _tmp337_;
				_tmp337_ = ordered;
				_tmp335_ = !_tmp337_;
			}
			unordered_seen = _tmp335_;
			_tmp339_ = ordered_seen;
			if (!_tmp339_) {
				_tmp338_ = TRUE;
			} else {
				gboolean _tmp340_;
				_tmp340_ = unordered_seen;
				_tmp338_ = !_tmp340_;
			}
			if (_tmp338_) {
				gboolean _tmp341_;
				_tmp341_ = ordered;
				if (_tmp341_) {
					ValaSymbol* prev = NULL;
					ValaMap* _tmp342_;
					gint _tmp343_;
					gpointer _tmp344_;
					ValaSymbol* _tmp345_;
					ValaMap* _tmp357_;
					gint _tmp358_;
					ValaSymbol* _tmp359_;
					_tmp342_ = positions;
					_tmp343_ = ordering;
					_tmp344_ = vala_map_get (_tmp342_, (gpointer) ((gintptr) _tmp343_));
					prev = (ValaSymbol*) _tmp344_;
					_tmp345_ = prev;
					if (_tmp345_ != NULL) {
						ValaSymbol* _tmp346_;
						ValaSourceReference* _tmp347_;
						ValaSourceReference* _tmp348_;
						ValaSymbol* _tmp349_;
						gchar* _tmp350_;
						gchar* _tmp351_;
						ValaSymbol* _tmp352_;
						const gchar* _tmp353_;
						const gchar* _tmp354_;
						gchar* _tmp355_;
						gchar* _tmp356_;
						_tmp346_ = sym;
						_tmp347_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp346_);
						_tmp348_ = _tmp347_;
						_tmp349_ = sym;
						_tmp350_ = vala_symbol_get_full_name (_tmp349_);
						_tmp351_ = _tmp350_;
						_tmp352_ = prev;
						_tmp353_ = vala_symbol_get_name (_tmp352_);
						_tmp354_ = _tmp353_;
						_tmp355_ = g_strdup_printf ("%s: Duplicate ordering (previous virtual with the same position is %s)", _tmp351_, _tmp354_);
						_tmp356_ = _tmp355_;
						vala_report_error (_tmp348_, _tmp356_);
						_g_free0 (_tmp356_);
						_g_free0 (_tmp351_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp357_ = positions;
					_tmp358_ = ordering;
					_tmp359_ = sym;
					vala_map_set (_tmp357_, (gpointer) ((gintptr) _tmp358_), _tmp359_);
					_vala_code_node_unref0 (prev);
				}
			}
			_vala_code_node_unref0 (sym);
		}
		_vala_iterable_unref0 (_sym_list);
	}
	_tmp360_ = ordered_seen;
	if (_tmp360_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp361_ = FALSE;
				_tmp361_ = TRUE;
				while (TRUE) {
					gint _tmp363_;
					ValaList* _tmp364_;
					gint _tmp365_;
					gint _tmp366_;
					ValaSymbol* sym = NULL;
					ValaMap* _tmp367_;
					gint _tmp368_;
					gpointer _tmp369_;
					ValaSymbol* _tmp370_;
					gboolean _tmp378_;
					gboolean _tmp379_;
					if (!_tmp361_) {
						gint _tmp362_;
						_tmp362_ = i;
						i = _tmp362_ + 1;
					}
					_tmp361_ = FALSE;
					_tmp363_ = i;
					_tmp364_ = self->priv->virtuals;
					_tmp365_ = vala_collection_get_size ((ValaCollection*) _tmp364_);
					_tmp366_ = _tmp365_;
					if (!(_tmp363_ < _tmp366_)) {
						break;
					}
					_tmp367_ = positions;
					_tmp368_ = i;
					_tmp369_ = vala_map_get (_tmp367_, (gpointer) ((gintptr) _tmp368_));
					sym = (ValaSymbol*) _tmp369_;
					_tmp370_ = sym;
					if (_tmp370_ == NULL) {
						ValaSourceReference* _tmp371_;
						ValaSourceReference* _tmp372_;
						gchar* _tmp373_;
						gchar* _tmp374_;
						gint _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						_tmp371_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp372_ = _tmp371_;
						_tmp373_ = vala_symbol_get_full_name ((ValaSymbol*) self);
						_tmp374_ = _tmp373_;
						_tmp375_ = i;
						_tmp376_ = g_strdup_printf ("%s: Gap in ordering in position %d", _tmp374_, _tmp375_);
						_tmp377_ = _tmp376_;
						vala_report_error (_tmp372_, _tmp377_);
						_g_free0 (_tmp377_);
						_g_free0 (_tmp374_);
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
					_tmp378_ = vala_code_node_get_error ((ValaCodeNode*) self);
					_tmp379_ = _tmp378_;
					if (!_tmp379_) {
						ValaList* _tmp380_;
						gint _tmp381_;
						ValaSymbol* _tmp382_;
						_tmp380_ = self->priv->virtuals;
						_tmp381_ = i;
						_tmp382_ = sym;
						vala_list_set (_tmp380_, _tmp381_, _tmp382_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	_tmp383_ = vala_code_context_get_analyzer (context);
	_tmp384_ = _tmp383_;
	_tmp385_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp384_, _tmp385_);
	_tmp386_ = vala_code_context_get_analyzer (context);
	_tmp387_ = _tmp386_;
	_tmp388_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp387_, _tmp388_);
	_tmp389_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp390_ = _tmp389_;
	result = !_tmp390_;
	_vala_map_unref0 (positions);
	_vala_code_node_unref0 (prereq_class);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static void
vala_interface_class_init (ValaInterfaceClass * klass)
{
	vala_interface_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_interface_finalize;
	g_type_class_add_private (klass, sizeof (ValaInterfacePrivate));
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_interface_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_interface_real_add_property;
	((ValaInterfaceClass *) klass)->get_virtuals = (ValaList* (*) (ValaInterface*)) vala_interface_real_get_virtuals;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_interface_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_interface_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_interface_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_interface_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_interface_real_check;
}


static void
vala_interface_instance_init (ValaInterface * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_INTERFACE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->prerequisites = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->virtuals = (ValaList*) _tmp3_;
}


static void
vala_interface_finalize (ValaCodeNode * obj)
{
	ValaInterface * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INTERFACE, ValaInterface);
	_vala_iterable_unref0 (self->priv->prerequisites);
	_vala_iterable_unref0 (self->priv->virtuals);
	VALA_CODE_NODE_CLASS (vala_interface_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_interface_get_type (void)
{
	static volatile gsize vala_interface_type_id__volatile = 0;
	if (g_once_init_enter (&vala_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInterfaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_interface_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInterface), 0, (GInstanceInitFunc) vala_interface_instance_init, NULL };
		GType vala_interface_type_id;
		vala_interface_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaInterface", &g_define_type_info, 0);
		g_once_init_leave (&vala_interface_type_id__volatile, vala_interface_type_id);
	}
	return vala_interface_type_id__volatile;
}



