/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.5
 * December 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef FIXED_H
#define FIXED_H
#include <vdk/widcontain.h>
#include <vdk/dlist.h>
/*!
  \class VDKFixed
  \brief This class wraps gtkfixed container

  In this container the gtk+ auto layout capability is disabled,
  all widgets are inserted in a fixed way with theri owns coordinates.
 */
class VDKFixed: public VDKObjectContainer
{
public:
  VDKFixed(VDKForm* owner);
  virtual ~VDKFixed();
  /*!
    Add an object to a fixed at <x>,<y> coordinates.
    \internal
    \par Tip
    user should ignore this method since is used mostby the vdkbuilder.
  */
  virtual void Add(VDKObject* obj, int justify = l_justify,
		   int expand = TRUE, int fill = TRUE , int padding = 0);
  /*!
    Add an object to fixed using coordinates.
    \param x x coordinate relative to fixed origin
    \param y y coordinate relative to fixed origin
   */
  void Put(VDKObject* obj, int x, int y);
};
#endif

