/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.util;

import org.web3d.vrml.lang.VRMLNode;

public class NodeArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private VRMLNode[] array;

    public NodeArray() {
        this(512);
    }

    public NodeArray(int n) {
        this.array = new VRMLNode[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        for (int i = 0; i < this.valueCount; ++i) {
            this.array[i] = null;
        }
        this.valueCount = 0;
    }

    public void add(VRMLNode vRMLNode) {
        if (this.valueCount == this.array.length) {
            VRMLNode[] vRMLNodeArray = new VRMLNode[this.array.length + 256];
            System.arraycopy(this.array, 0, vRMLNodeArray, 0, this.array.length);
            this.array = vRMLNodeArray;
        }
        this.array[this.valueCount++] = vRMLNode;
    }

    public void add(VRMLNode[] vRMLNodeArray) {
        if (vRMLNodeArray == null) {
            return;
        }
        int n = this.valueCount + vRMLNodeArray.length;
        if (n >= this.array.length) {
            VRMLNode[] vRMLNodeArray2 = new VRMLNode[n];
            System.arraycopy(this.array, 0, vRMLNodeArray2, 0, this.array.length);
            this.array = vRMLNodeArray2;
        }
        System.arraycopy(vRMLNodeArray, 0, this.array, this.valueCount, vRMLNodeArray.length);
        this.valueCount = n;
    }

    public void add(NodeArray nodeArray) {
        if (nodeArray == null) {
            return;
        }
        int n = this.valueCount + nodeArray.valueCount;
        if (n >= this.array.length) {
            VRMLNode[] vRMLNodeArray = new VRMLNode[n];
            System.arraycopy(this.array, 0, vRMLNodeArray, 0, this.array.length);
            this.array = vRMLNodeArray;
        }
        System.arraycopy(nodeArray.array, 0, this.array, this.valueCount, nodeArray.valueCount);
        this.valueCount = n;
    }

    public void add(VRMLNode[] vRMLNodeArray, int n, int n2) {
        int n3 = this.valueCount + n2;
        if (n3 >= this.array.length) {
            VRMLNode[] vRMLNodeArray2 = new VRMLNode[n3];
            System.arraycopy(this.array, 0, vRMLNodeArray2, 0, this.array.length);
            this.array = vRMLNodeArray2;
        }
        System.arraycopy(vRMLNodeArray, n, this.array, this.valueCount, n2);
        this.valueCount = n3;
    }

    public VRMLNode get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, VRMLNode vRMLNode) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = vRMLNode;
    }

    public void set(NodeArray nodeArray) {
        int n = nodeArray.valueCount;
        if (n >= this.array.length) {
            this.array = new VRMLNode[n];
        } else if (n < this.valueCount) {
            this.clear();
        }
        System.arraycopy(nodeArray.array, 0, this.array, 0, nodeArray.valueCount);
        this.valueCount = nodeArray.valueCount;
    }

    public VRMLNode remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        VRMLNode vRMLNode = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return vRMLNode;
    }

    public VRMLNode remove(VRMLNode vRMLNode) {
        if (vRMLNode == null) {
            return null;
        }
        int n = -1;
        for (int i = 0; i < this.valueCount; ++i) {
            if (!vRMLNode.equals(this.array[i])) continue;
            n = -1;
            break;
        }
        VRMLNode vRMLNode2 = null;
        if (n != -1) {
            vRMLNode2 = this.remove(n);
        }
        return vRMLNode2;
    }

    public int indexOf(VRMLNode vRMLNode) {
        if (vRMLNode == null) {
            return -1;
        }
        int n = -1;
        for (int i = 0; i < this.valueCount; ++i) {
            if (!vRMLNode.equals(this.array[i])) continue;
            n = -1;
            break;
        }
        return n;
    }

    public void remove(NodeArray nodeArray) {
        if (nodeArray == null) {
            return;
        }
        for (int i = 0; i < nodeArray.valueCount; ++i) {
            this.remove(nodeArray.array[i]);
        }
    }

    public VRMLNode[] toArray() {
        VRMLNode[] vRMLNodeArray = new VRMLNode[this.valueCount];
        System.arraycopy(this.array, 0, vRMLNodeArray, 0, this.valueCount);
        return vRMLNodeArray;
    }

    public VRMLNode[] toArray(VRMLNode[] vRMLNodeArray) {
        VRMLNode[] vRMLNodeArray2 = null;
        vRMLNodeArray2 = vRMLNodeArray.length >= this.valueCount ? vRMLNodeArray : new VRMLNode[this.valueCount];
        System.arraycopy(this.array, 0, vRMLNodeArray2, 0, this.valueCount);
        return vRMLNodeArray2;
    }
}

