/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.nodes;

import java.util.HashMap;
import java.util.Set;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.InvalidFieldAccessException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.TypeConstants;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;

public class ImportNodeProxy
implements VRMLNodeType,
VRMLNodeListener,
Cloneable {
    private static final String IMPORT_NODE_NAME = "ImportProxy";
    private final String importedName;
    private final String inlineName;
    private final String exportedName;
    private final VRMLFieldData fieldData;
    private ErrorReporter errorReporter;
    private IntHashMap fieldChangedFlags;
    private int vrmlMajorVersion;
    private int vrmlMinorVersion;
    private FrameStateManager stateManager;
    private VRMLNodeListener nodeListener;
    private int lastFieldIndex;
    private VRMLNodeType realNode;
    private HashMap nameToIndexMap;
    private IntHashMap indexToRealIndexMap;
    private IntHashMap realIndexToIndexMap;
    private IntHashMap fieldDeclMap;

    public ImportNodeProxy(String string, String string2, String string3) {
        this.importedName = string;
        this.inlineName = string2;
        this.exportedName = string3;
        this.fieldData = new VRMLFieldData();
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.nameToIndexMap = new HashMap();
        this.fieldDeclMap = new IntHashMap();
        this.fieldChangedFlags = new IntHashMap();
        this.indexToRealIndexMap = new IntHashMap();
        this.realIndexToIndexMap = new IntHashMap();
    }

    public void allEventsComplete() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public String getVRMLNodeName() {
        return IMPORT_NODE_NAME;
    }

    public boolean isDEF() {
        return false;
    }

    public int getPrimaryType() {
        return -2;
    }

    public int[] getSecondaryType() {
        return TypeConstants.NO_SECONDARY_TYPE;
    }

    public void setVersion(int n, int n2, boolean bl) {
        this.vrmlMajorVersion = n;
        this.vrmlMinorVersion = n2;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.realNode == null ? (VRMLFieldDeclaration)this.fieldDeclMap.get(n) : this.realNode.getFieldDeclaration(n);
        return vRMLFieldDeclaration;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)this.nameToIndexMap.get(string);
        if (n == null) {
            if (this.realNode != null) {
                int n2 = this.realNode.getFieldIndex(string);
                if (n2 == -1) {
                    return -1;
                }
                this.indexToRealIndexMap.put(this.lastFieldIndex, new Integer(n2));
                n = new Integer(this.lastFieldIndex++);
                this.realIndexToIndexMap.put(n2, n);
            } else {
                VRMLFieldDeclaration vRMLFieldDeclaration = new VRMLFieldDeclaration(-1, "UnknownImportedField", string);
                this.fieldDeclMap.put(this.lastFieldIndex, vRMLFieldDeclaration);
                n = new Integer(this.lastFieldIndex++);
            }
            this.nameToIndexMap.put(string, n);
            this.fieldChangedFlags.put(n, Boolean.FALSE);
        }
        return n == null ? -1 : n;
    }

    public int getNumFields() {
        return this.lastFieldIndex;
    }

    public int[] getNodeFieldIndices() {
        return this.realNode == null ? null : this.realNode.getNodeFieldIndices();
    }

    public void setUserData(int n, Object object) throws InvalidFieldException {
    }

    public Object getUserData(int n) throws InvalidFieldException {
        return null;
    }

    public void setMetadataObject(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
    }

    public VRMLNodeType getMetadataObject() {
        return null;
    }

    public boolean isSetupFinished() {
        return true;
    }

    public void setupFinished() {
    }

    public void setDEF() {
    }

    public int getRefCount(int n) {
        return 0;
    }

    public void updateRefCount(int n, boolean bl) {
    }

    public int[] getLayerIds() {
        return null;
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
    }

    public boolean hasFieldChanged(int n) {
        Boolean bl = (Boolean)this.fieldChangedFlags.get(n);
        this.fieldChangedFlags.put(n, Boolean.FALSE);
        return bl;
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        if (this.realNode == null) {
            return;
        }
        Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
        this.realNode.sendRoute(d, n3, vRMLNodeType, n2);
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add(this.nodeListener, vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove(this.nodeListener, vRMLNodeListener);
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        if (this.realNode != null) {
            Integer n2 = (Integer)this.indexToRealIndexMap.get(n);
            if (n2 == null) {
                throw new InvalidFieldException("Unable to locate imported node's field");
            }
            return this.realNode.getFieldValue(n2);
        }
        return this.fieldData;
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, n2);
        }
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, nArray, n2);
        }
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n2 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n2, bl);
        }
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, blArray, n2);
        }
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n2 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n2, f);
        }
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, fArray, n2);
        }
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n2 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n2, l);
        }
    }

    public void setValue(int n, long[] lArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, lArray, n2);
        }
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n2 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n2, d);
        }
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, dArray, n2);
        }
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n2 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n2, string);
        }
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, stringArray, n2);
        }
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n2 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n2, vRMLNodeType);
        }
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException, InvalidFieldAccessException {
        if (this.realNode != null) {
            Integer n3 = (Integer)this.indexToRealIndexMap.get(n);
            this.realNode.setValue((int)n3, vRMLNodeTypeArray, n2);
        }
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
    }

    public void fieldChanged(int n) {
        Integer n2 = (Integer)this.realIndexToIndexMap.get(n);
        if (n2 != null) {
            this.fieldChangedFlags.put(n2, Boolean.TRUE);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ImportNodeProxy importNodeProxy = (ImportNodeProxy)super.clone();
        importNodeProxy.realNode = null;
        importNodeProxy.nodeListener = null;
        importNodeProxy.fieldChangedFlags = new IntHashMap();
        importNodeProxy.nameToIndexMap = (HashMap)this.nameToIndexMap.clone();
        importNodeProxy.indexToRealIndexMap = (IntHashMap)this.indexToRealIndexMap.clone();
        importNodeProxy.realIndexToIndexMap = (IntHashMap)this.realIndexToIndexMap.clone();
        importNodeProxy.fieldDeclMap = (IntHashMap)this.fieldDeclMap.clone();
        return importNodeProxy;
    }

    public void setRealNode(VRMLNodeType vRMLNodeType) {
        if (vRMLNodeType == null) {
            if (this.realNode != null) {
                this.realNode.removeNodeListener(this);
            }
            this.indexToRealIndexMap.clear();
            this.realNode = vRMLNodeType;
        } else {
            if (this.realNode != null) {
                this.realNode.removeNodeListener(this);
            }
            this.realNode = vRMLNodeType;
            this.realNode.addNodeListener(this);
            Set set = this.nameToIndexMap.keySet();
            for (String string : set) {
                int n = this.realNode.getFieldIndex(string);
                if (n == -1) {
                    this.errorReporter.warningReport("Imported node " + this.importedName + " does not contain the " + "requested field name " + string, null);
                    continue;
                }
                Integer n2 = (Integer)this.nameToIndexMap.get(string);
                this.indexToRealIndexMap.put(n2, new Integer(n));
                this.realIndexToIndexMap.put(n, n2);
            }
        }
    }

    public VRMLNodeType getRealNode() {
        return this.realNode;
    }

    public String getInlineDEFName() {
        return this.inlineName;
    }

    public String getExportedName() {
        return this.exportedName;
    }

    public String getImportedName() {
        return this.importedName;
    }

    private void fireFieldChanged(int n) {
        if (this.nodeListener != null) {
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

