/*
 * NodeVrmlCut.h
 *
 * Copyright (C) 1999 Stephen F. White
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program (see the file "COPYING" for details); if 
 * not, write to the Free Software Foundation, Inc., 675 Mass Ave, 
 * Cambridge, MA 02139, USA.
 */

#ifndef _NODE_VRML_CUT_H
#define _NODE_VRML_CUT_H

#ifndef _NODE_H
#include "Node.h"
#endif
#ifndef _PROTO_MACROS_H
#include "ProtoMacros.h"
#endif
#ifndef _PROTO_H
#include "Proto.h"
#endif
#include "SFMFTypes.h"
#include "CommandList.h"
#include "DynamicFieldsNode.h"

class ProtoVrmlCut : public Proto {
public:
                    ProtoVrmlCut(Scene *scene);
    virtual Node   *create(Scene *scene);

    virtual int     getType() const { return DUNE_VRML_CUT; }

    FieldIndex sceneLengths;
    FieldIndex sceneNumber;
    FieldIndex scenes;
    FieldIndex numberPreviousScenes;
    FieldIndex numberNextScenes;

    virtual bool    isScriptedProto(void) { return true; }

    int getFirstDynamicEventOut() { return _firstDynamicEventOut; }
protected:
    int _firstDynamicEventOut;
};

class NodeVrmlCut : public DynamicFieldsNode {
public:
                    NodeVrmlCut(Scene *scene, Proto* proto);
                    NodeVrmlCut(Node *node, Proto* proto) : 
                               DynamicFieldsNode(node, proto) 
                       { initialize(); }

    void            initialize(void);

    fieldMacros(MFTime,  sceneLengths,         ProtoVrmlCut)
    fieldMacros(SFInt32, sceneNumber,          ProtoVrmlCut)
    fieldMacros(MFNode,  scenes,               ProtoVrmlCut)
    fieldMacros(SFInt32, numberPreviousScenes, ProtoVrmlCut)
    fieldMacros(SFInt32, numberNextScenes,     ProtoVrmlCut)

    virtual int     getProfile(void) const { return PROFILE_IMMERSIVE; }
    virtual Node   *copy() const { return new NodeVrmlCut(*this); }

    virtual int     write(int filedes, int indent) 
                       { return Node::write(filedes, indent); }
    virtual int     writeProto(int filedes);
    virtual int     writeXmlProto(int filedes);
    virtual int     writeJavaScript(int filedes);

    virtual void    updateTime(void);

    virtual void    preDraw();
    virtual void    draw(int pass);

    virtual void    flip(int index) { scenes()->flip(index); }    
    virtual void    swap(int fromTo) { scenes()->swap(fromTo); }

    virtual int     countPolygons(void)
                       { return scenes()->countPolygons(); } 
    virtual int     countPrimitives(void) 
                       { return scenes()->countPrimitives(); } 

    virtual int     countPolygons1Sided(void)
                       { return scenes()->countPolygons1Sided(); } 
    virtual int     countPolygons2Sided(void)
                       { return scenes()->countPolygons2Sided(); } 

    virtual bool    showFields() { return true; }

    virtual void    setField(int index, FieldValue *value);

    virtual void    update();
    void            updateCycleInterval(Node *vrmlScene, SFTime *interval);

protected:
    virtual        ~NodeVrmlCut();

    char           *newStartTimeName(void);
    void            startNextScene(int currentScene, double time);
    int             accountWhich();
    void            accountAllSceneLengths();

protected:
    int            _firstScene;
    int            _lastScene;
    double         _allSceneLengths;
    int            _currentScene;
};

#endif // _NODE_VRML_CUT_H
