#!/usr/bin/env python

import binascii
from Crypto.PublicKey import RSA
from Crypto.Util.number import long_to_bytes, bytes_to_long

def main():
	n=27726986726566980701186140548734841892774214948497220646426857063406993516700854816346940097676716265075283165557603638068377810137093304291501735117759519974032821924958184777202294814151973835788532652439000247892847024622491682490709368037186384771396814631500219595024820877009976296538536357772745276936951835040104553951876629891149800713649783625082809180632289619778764273320341353246025774964293304797026312103747048463983247264958205404138001283737460386544315493005952178833676389527845395918909191154200705174526105063933073665602368865922234225943036985348054212177575354956661062703890780353892888298297
	e=65537
	d=18409209659171293029139456088882603342848839816499985687290718699361101498271271123544019477092435644631594311349436304732736067450376748243528312253827150962511103352620740867149906987628283832288118487351850371340791500715603103288497134922289564071559418268466195511517387595119323414121508957318239547665335084247333420400801232511241583935377237492348802495727635909379057531579309227176856055276102318312114120530487042021615790913190026314512804950567071659043148333844588880563549291111213425725362257151918487042702703002265103049651388733403750767856859506048733643602957984039833939350329239234776543917697
	key = RSA.construct((long(n), long(e), long(d)))
	assert key.n==n
	assert key.e==e
	assert key.d==d
	print "key=%s" % key

	oks='20918012978331737122824096969613145818473112500234571192247520290629533899357757297915317251174161188034248051952647871116284179186793496415110761971985870674681422899949392247605492600778305980287935771054671087210027186473381865015084568237047157986157891180747617991581783558881306615783956107145429093953588050835954712003005003500032480955126971777511109866099771118228251580826378682605182060793149986647008905112842385731194667664388291331886495603911832786163497680988990911207869194725511918952292699364529520520019077511400820915831254275351789222897758406985645911064510855069089072127323079432880231576682'
	ok=long(oks)
	print "ok=%s" % ok
	hexok = "".join(binascii.hexlify(c) for c in long_to_bytes(ok))
	print "hex(ok)=%s" % hexok
	print "len(hex(ok))=%s" % len(hexok)
	

	msg = "test"
	message = msg.encode("utf-8")
	print "bytes(%s)=***** 0x%s *****" % (msg, binascii.hexlify(message))
	l = bytes_to_long(message)
	print "long(%s)=%s=%s" % (message, l, hex(l))
	enc = key.encrypt(l, '')
	#print "%s.encrypt(%s)=%s" % (key, message, enc)
	for x in enc:
		print "encrypt(%s)=***** 0x%s *****" % (message, binascii.hexlify(long_to_bytes(x)))
		dec = key.decrypt(x)
		print "decrypt(..)=***** 0x%s *****" % (binascii.hexlify(long_to_bytes(dec)))
		print "decrypt(..)=***** %s *****" % (long_to_bytes(dec).decode("utf-8"))
	print
	
	
	sig = key.sign(message, '')
	#print "%s.sign(%s)=%s" % (key, message, sig)
	for x in sig:
		print "sign(%s)=***** 0x%s *****" % (message, binascii.hexlify(long_to_bytes(x)))
		enc = key.encrypt(x, '')
		print "encrypt(..)=***** %s *****" % enc
		for e in enc:
			print "encrypt(..)=***** %s *****" % long_to_bytes(e)
			print "encrypt(..)=***** 0x%s *****" % (binascii.hexlify(long_to_bytes(e)))
	dec = key.decrypt(bytes_to_long(message))
	print "decrypt(%s)=***** 0x%s *****" % (message, binascii.hexlify(long_to_bytes(dec)))
	print

	print "token:"
	salt = "85281da1-4eb8-4b16-a6f9-3ba016def776"
	sig = key.sign(salt, '')
	for x in sig:
		print "sign(%s)=***** 0x%s *****" % (salt, binascii.hexlify(long_to_bytes(x)))
		enc = key.encrypt(x, '')
		print "encrypt(..)=***** %s *****" % enc
		for e in enc:
			print "encrypt(..)=***** %s *****" % long_to_bytes(e)
			print "encrypt(..)=***** 0x%s *****" % (binascii.hexlify(long_to_bytes(e)))


if __name__ == "__main__":
	main()
