//////////////////////////////////////////////////////////////////////////////
// Name:        SVGVideoElement.h
// Author:      Alex Thuering
// Copyright:   (c) 2005 Alex Thuering
// Licence:     wxWindows licence
// Notes:       generated by generate.py
//////////////////////////////////////////////////////////////////////////////

#ifndef WX_SVG_VIDEO_ELEMENT_H
#define WX_SVG_VIDEO_ELEMENT_H

class wxSVGCanvasItem;
class wxProgressDialog;

#include "SVGElement.h"
#include "SVGURIReference.h"
#include "SVGLangSpace.h"
#include "SVGStylable.h"
#include "SVGTransformable.h"
#include "SVGAnimatedLength.h"
#include "SVGAnimatedPreserveAspectRatio.h"
#include "SVGSVGElement.h"
#include "String_wxsvg.h"
#include "Element.h"

class wxSVGVideoElement:
  public wxSVGElement,
  public wxSVGURIReference,
  public wxSVGLangSpace,
  public wxSVGStylable,
  public wxSVGTransformable
{
  protected:
    wxSVGAnimatedLength m_x;
    wxSVGAnimatedLength m_y;
    wxSVGAnimatedLength m_width;
    wxSVGAnimatedLength m_height;
    wxSVGAnimatedPreserveAspectRatio m_preserveAspectRatio;
    double m_begin;
    double m_dur;
    double m_clipBegin;
    double m_clipEnd;

  public:
    inline const wxSVGAnimatedLength& GetX() const { WX_SVG_ANIM_LENGTH_CALC_WIDTH(m_x, GetViewportElement()); return m_x; }
    inline void SetX(const wxSVGAnimatedLength& n) { m_x = n; }
    inline void SetX(const wxSVGLength& n) { m_x.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetY() const { WX_SVG_ANIM_LENGTH_CALC_HEIGHT(m_y, GetViewportElement()); return m_y; }
    inline void SetY(const wxSVGAnimatedLength& n) { m_y = n; }
    inline void SetY(const wxSVGLength& n) { m_y.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetWidth() const { WX_SVG_ANIM_LENGTH_CALC_WIDTH(m_width, GetViewportElement()); return m_width; }
    inline void SetWidth(const wxSVGAnimatedLength& n) { m_width = n; }
    inline void SetWidth(const wxSVGLength& n) { m_width.SetBaseVal(n); }

    inline const wxSVGAnimatedLength& GetHeight() const { WX_SVG_ANIM_LENGTH_CALC_HEIGHT(m_height, GetViewportElement()); return m_height; }
    inline void SetHeight(const wxSVGAnimatedLength& n) { m_height = n; }
    inline void SetHeight(const wxSVGLength& n) { m_height.SetBaseVal(n); }

    inline const wxSVGAnimatedPreserveAspectRatio& GetPreserveAspectRatio() const { return m_preserveAspectRatio; }
    inline void SetPreserveAspectRatio(const wxSVGAnimatedPreserveAspectRatio& n) { m_preserveAspectRatio = n; }
    inline void SetPreserveAspectRatio(const wxSVGPreserveAspectRatio& n) { m_preserveAspectRatio.SetBaseVal(n); }

    inline double GetBegin() const { return m_begin; }
    inline void SetBegin(double n) { m_begin = n; }

    inline double GetDur() const { return m_dur; }
    inline void SetDur(double n) { m_dur = n; }

    inline double GetClipBegin() const { return m_clipBegin; }
    inline void SetClipBegin(double n) { m_clipBegin = n; }

    inline double GetClipEnd() const { return m_clipEnd; }
    inline void SetClipEnd(double n) { m_clipEnd = n; }

  protected:
    wxSVGCanvasItem* m_canvasItem;
  public:
    inline wxSVGCanvasItem* GetCanvasItem() { return m_canvasItem; }
    void SetCanvasItem(wxSVGCanvasItem* canvasItem);

  public:
    wxSVGVideoElement(wxString tagName = wxT("video")):
      wxSVGElement(tagName), m_begin(0), m_dur(0), m_clipBegin(0), m_clipEnd(0), m_canvasItem(NULL) {}
    wxSVGVideoElement(wxSVGVideoElement& src);
    virtual ~wxSVGVideoElement();
    wxSvgXmlNode* CloneNode(bool deep = true) { return new wxSVGVideoElement(*this); }
    wxSVGRect GetBBox(wxSVG_COORDINATES coordinates = wxSVG_COORDINATES_USER);
    wxSVGRect GetResultBBox(wxSVG_COORDINATES coordinates = wxSVG_COORDINATES_USER);
    wxSVGMatrix GetCTM() { return wxSVGLocatable::GetCTM(this); }
    wxSVGMatrix GetScreenCTM() { return wxSVGLocatable::GetScreenCTM(this); }
    double GetDuration(wxProgressDialog* progressDlg = NULL);
    bool HasAttribute(const wxString& name);
    wxString GetAttribute(const wxString& name);
    bool SetAttribute(const wxString& name, const wxString& value);
    wxSvgXmlAttrHash GetAttributes() const;
    virtual wxSVGDTD GetDtd() const { return wxSVG_VIDEO_ELEMENT; }
};

#endif // WX_SVG_VIDEO_ELEMENT_H
