package storage

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"github.com/chromedp/cdproto/cdp"
)

// EventCacheStorageContentUpdated a cache's contents have been modified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-cacheStorageContentUpdated
type EventCacheStorageContentUpdated struct {
	Origin     string `json:"origin"`     // Origin to update.
	StorageKey string `json:"storageKey"` // Storage key to update.
	CacheName  string `json:"cacheName"`  // Name of cache in origin.
}

// EventCacheStorageListUpdated a cache has been added/deleted.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-cacheStorageListUpdated
type EventCacheStorageListUpdated struct {
	Origin     string `json:"origin"`     // Origin to update.
	StorageKey string `json:"storageKey"` // Storage key to update.
}

// EventIndexedDBContentUpdated the origin's IndexedDB object store has been
// modified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-indexedDBContentUpdated
type EventIndexedDBContentUpdated struct {
	Origin          string `json:"origin"`          // Origin to update.
	StorageKey      string `json:"storageKey"`      // Storage key to update.
	DatabaseName    string `json:"databaseName"`    // Database to update.
	ObjectStoreName string `json:"objectStoreName"` // ObjectStore to update.
}

// EventIndexedDBListUpdated the origin's IndexedDB database list has been
// modified.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-indexedDBListUpdated
type EventIndexedDBListUpdated struct {
	Origin     string `json:"origin"`     // Origin to update.
	StorageKey string `json:"storageKey"` // Storage key to update.
}

// EventInterestGroupAccessed one of the interest groups was accessed by the
// associated page.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-interestGroupAccessed
type EventInterestGroupAccessed struct {
	AccessTime  *cdp.TimeSinceEpoch     `json:"accessTime"`
	Type        InterestGroupAccessType `json:"type"`
	OwnerOrigin string                  `json:"ownerOrigin"`
	Name        string                  `json:"name"`
}

// EventSharedStorageAccessed shared storage was accessed by the associated
// page. The following parameters are included in all events.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Storage#event-sharedStorageAccessed
type EventSharedStorageAccessed struct {
	AccessTime  *cdp.TimeSinceEpoch        `json:"accessTime"`  // Time of the access.
	Type        SharedStorageAccessType    `json:"type"`        // Enum value indicating the Shared Storage API method invoked.
	MainFrameID cdp.FrameID                `json:"mainFrameId"` // DevTools Frame Token for the primary frame tree's root.
	OwnerOrigin string                     `json:"ownerOrigin"` // Serialized origin for the context that invoked the Shared Storage API.
	Params      *SharedStorageAccessParams `json:"params"`      // The sub-parameters warapped by params are all optional and their presence/absence depends on type.
}
